/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFrdHinfo (FILE *fp, int Size, struct AF_info *Hinfo, int Align)

Purpose:
  Read AFsp information records 

Description:
  This routine reads AFsp information records from a file.  These records are
  prefixed by an identification string ("AFsp").  The information records from
  the file are appended to existing records in the AFsp information structure.

  The last information record is null terminated if the header information is
  not truncated.

Parameters:
  <-  int AFrdHinfo
      Number of characters read (including any skipped characters)
   -> int Size
      Number of characters in the text string
  <-> struct AF_info *Hinfo
      AFsp information structure
   -> int Align
      Alignment requirement.  If Size is not a multiple of Align, file data
      up to the next multiple of Align is skipped, leaving the file positioned
      at that point.

Author / revision:
  P. Kabal  Copyright (C) 1998
  $Revision: 1.2 $  $Date: 1998/06/19 18:51:13 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: AFrdHinfo.c 1.2 1998/06/19 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/AFheader.h>
#include <libtsp/AFmsg.h>
#include <libtsp/AFpar.h>

#define ICEILV(n,m)	(((n) + ((m) - 1)) / (m))	/* int n,m >= 0 */
#define RNDUPV(n,m)	((m) * ICEILV (n, m))		/* Round up */

#define SAME_CSTR(str,ref) 	(memcmp (str, ref, sizeof (str)) == 0)


int
AFrdHinfo (fp, Size, Hinfo, Align)

     FILE *fp;
     int Size;
     struct AF_info *Hinfo;
     int Align;

{
  int N, offs;
  char ID[4];

  N = 0;
  offs = 0;
  if (Size > 4) {
    offs += RHEAD_S (fp, ID);

    /* Read the header information records */
    if (SAME_CSTR (ID, FM_AFSP)) {
      N = Size - offs;
      if (N > AF_MAXINFO) {
	UTwarn ("AFrdAUhead - %s", AFM_AU_TruncInfo);
	N = AF_MAXINFO;
      }
      offs += RHEAD_SN (fp, Hinfo->Info, N);
    }
  }
  offs += RSKIP (fp, RNDUPV (Size, Align) - offs); /* Skip past the data */

  /* Add a terminating null if necessary */
  if (N > 0 && N < AF_MAXINFO && Hinfo->Info[N-1] != '\0') {
    Hinfo->Info[N] = '\0';
    ++N;
  }

  Hinfo->N = N;

  return offs;
}
