// Copyright 2008 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * @fileoverview Default list of locale specific country and language names.
 *
 * File generated from CLDR ver. 32
 *
 */

// clang-format off

/**
 * Namespace for locale specific country and lanugage names
 */
goog.provide('goog.locale.defaultLocaleNameConstants');

/**
 * Default list of locale specific country and language names
 * @const
 */
goog.locale.defaultLocaleNameConstants = {
  'COUNTRY': {
    '001': 'World',
    '002': 'Africa',
    '003': 'North America',
    '005': 'South America',
    '009': 'Oceania',
    '011': 'Western Africa',
    '013': 'Central America',
    '014': 'Eastern Africa',
    '015': 'Northern Africa',
    '017': 'Middle Africa',
    '018': 'Southern Africa',
    '019': 'Americas',
    '021': 'Northern America',
    '029': 'Caribbean',
    '030': 'Eastern Asia',
    '034': 'Southern Asia',
    '035': 'Southeast Asia',
    '039': 'Southern Europe',
    '053': 'Australasia',
    '054': 'Melanesia',
    '057': 'Micronesian Region',
    '061': 'Polynesia',
    '142': 'Asia',
    '143': 'Central Asia',
    '145': 'Western Asia',
    '150': 'Europe',
    '151': 'Eastern Europe',
    '154': 'Northern Europe',
    '155': 'Western Europe',
    '202': 'Sub-Saharan Africa',
    '419': 'Latin America',
    'AC': 'Ascension Island',
    'AD': 'Andorra',
    'AE': 'United Arab Emirates',
    'AF': 'Afghanistan',
    'AG': 'Antigua & Barbuda',
    'AI': 'Anguilla',
    'AL': 'Albania',
    'AM': 'Armenia',
    'AO': 'Angola',
    'AQ': 'Antarctica',
    'AR': 'Argentina',
    'AS': 'American Samoa',
    'AT': 'Austria',
    'AU': 'Australia',
    'AW': 'Aruba',
    'AX': 'Åland Islands',
    'AZ': 'Azerbaijan',
    'BA': 'Bosnia & Herzegovina',
    'BB': 'Barbados',
    'BD': 'Bangladesh',
    'BE': 'Belgium',
    'BF': 'Burkina Faso',
    'BG': 'Bulgaria',
    'BH': 'Bahrain',
    'BI': 'Burundi',
    'BJ': 'Benin',
    'BL': 'St. Barthélemy',
    'BM': 'Bermuda',
    'BN': 'Brunei',
    'BO': 'Bolivia',
    'BQ': 'Caribbean Netherlands',
    'BR': 'Brazil',
    'BS': 'Bahamas',
    'BT': 'Bhutan',
    'BV': 'Bouvet Island',
    'BW': 'Botswana',
    'BY': 'Belarus',
    'BZ': 'Belize',
    'CA': 'Canada',
    'CC': 'Cocos (Keeling) Islands',
    'CD': 'Congo - Kinshasa',
    'CF': 'Central African Republic',
    'CG': 'Congo - Brazzaville',
    'CH': 'Switzerland',
    'CI': 'Côte d’Ivoire',
    'CK': 'Cook Islands',
    'CL': 'Chile',
    'CM': 'Cameroon',
    'CN': 'China',
    'CO': 'Colombia',
    'CP': 'Clipperton Island',
    'CR': 'Costa Rica',
    'CU': 'Cuba',
    'CV': 'Cape Verde',
    'CW': 'Curaçao',
    'CX': 'Christmas Island',
    'CY': 'Cyprus',
    'CZ': 'Czechia',
    'DE': 'Germany',
    'DG': 'Diego Garcia',
    'DJ': 'Djibouti',
    'DK': 'Denmark',
    'DM': 'Dominica',
    'DO': 'Dominican Republic',
    'DZ': 'Algeria',
    'EA': 'Ceuta & Melilla',
    'EC': 'Ecuador',
    'EE': 'Estonia',
    'EG': 'Egypt',
    'EH': 'Western Sahara',
    'ER': 'Eritrea',
    'ES': 'Spain',
    'ET': 'Ethiopia',
    'EU': 'European Union',
    'EZ': 'Eurozone',
    'FI': 'Finland',
    'FJ': 'Fiji',
    'FK': 'Falkland Islands (Islas Malvinas)',
    'FM': 'Micronesia',
    'FO': 'Faroe Islands',
    'FR': 'France',
    'GA': 'Gabon',
    'GB': 'United Kingdom',
    'GD': 'Grenada',
    'GE': 'Georgia',
    'GF': 'French Guiana',
    'GG': 'Guernsey',
    'GH': 'Ghana',
    'GI': 'Gibraltar',
    'GL': 'Greenland',
    'GM': 'Gambia',
    'GN': 'Guinea',
    'GP': 'Guadeloupe',
    'GQ': 'Equatorial Guinea',
    'GR': 'Greece',
    'GS': 'South Georgia & South Sandwich Islands',
    'GT': 'Guatemala',
    'GU': 'Guam',
    'GW': 'Guinea-Bissau',
    'GY': 'Guyana',
    'HK': 'Hong Kong',
    'HM': 'Heard & McDonald Islands',
    'HN': 'Honduras',
    'HR': 'Croatia',
    'HT': 'Haiti',
    'HU': 'Hungary',
    'IC': 'Canary Islands',
    'ID': 'Indonesia',
    'IE': 'Ireland',
    'IL': 'Israel',
    'IM': 'Isle of Man',
    'IN': 'India',
    'IO': 'British Indian Ocean Territory',
    'IQ': 'Iraq',
    'IR': 'Iran',
    'IS': 'Iceland',
    'IT': 'Italy',
    'JE': 'Jersey',
    'JM': 'Jamaica',
    'JO': 'Jordan',
    'JP': 'Japan',
    'KE': 'Kenya',
    'KG': 'Kyrgyzstan',
    'KH': 'Cambodia',
    'KI': 'Kiribati',
    'KM': 'Comoros',
    'KN': 'St. Kitts & Nevis',
    'KP': 'North Korea',
    'KR': 'South Korea',
    'KW': 'Kuwait',
    'KY': 'Cayman Islands',
    'KZ': 'Kazakhstan',
    'LA': 'Laos',
    'LB': 'Lebanon',
    'LC': 'St. Lucia',
    'LI': 'Liechtenstein',
    'LK': 'Sri Lanka',
    'LR': 'Liberia',
    'LS': 'Lesotho',
    'LT': 'Lithuania',
    'LU': 'Luxembourg',
    'LV': 'Latvia',
    'LY': 'Libya',
    'MA': 'Morocco',
    'MC': 'Monaco',
    'MD': 'Moldova',
    'ME': 'Montenegro',
    'MF': 'St. Martin',
    'MG': 'Madagascar',
    'MH': 'Marshall Islands',
    'MK': 'Macedonia (FYROM)',
    'ML': 'Mali',
    'MM': 'Myanmar (Burma)',
    'MN': 'Mongolia',
    'MO': 'Macau',
    'MP': 'Northern Mariana Islands',
    'MQ': 'Martinique',
    'MR': 'Mauritania',
    'MS': 'Montserrat',
    'MT': 'Malta',
    'MU': 'Mauritius',
    'MV': 'Maldives',
    'MW': 'Malawi',
    'MX': 'Mexico',
    'MY': 'Malaysia',
    'MZ': 'Mozambique',
    'NA': 'Namibia',
    'NC': 'New Caledonia',
    'NE': 'Niger',
    'NF': 'Norfolk Island',
    'NG': 'Nigeria',
    'NI': 'Nicaragua',
    'NL': 'Netherlands',
    'NO': 'Norway',
    'NP': 'Nepal',
    'NR': 'Nauru',
    'NU': 'Niue',
    'NZ': 'New Zealand',
    'OM': 'Oman',
    'PA': 'Panama',
    'PE': 'Peru',
    'PF': 'French Polynesia',
    'PG': 'Papua New Guinea',
    'PH': 'Philippines',
    'PK': 'Pakistan',
    'PL': 'Poland',
    'PM': 'St. Pierre & Miquelon',
    'PN': 'Pitcairn Islands',
    'PR': 'Puerto Rico',
    'PS': 'Palestine',
    'PT': 'Portugal',
    'PW': 'Palau',
    'PY': 'Paraguay',
    'QA': 'Qatar',
    'QO': 'Outlying Oceania',
    'RE': 'Réunion',
    'RO': 'Romania',
    'RS': 'Serbia',
    'RU': 'Russia',
    'RW': 'Rwanda',
    'SA': 'Saudi Arabia',
    'SB': 'Solomon Islands',
    'SC': 'Seychelles',
    'SD': 'Sudan',
    'SE': 'Sweden',
    'SG': 'Singapore',
    'SH': 'St. Helena',
    'SI': 'Slovenia',
    'SJ': 'Svalbard & Jan Mayen',
    'SK': 'Slovakia',
    'SL': 'Sierra Leone',
    'SM': 'San Marino',
    'SN': 'Senegal',
    'SO': 'Somalia',
    'SR': 'Suriname',
    'SS': 'South Sudan',
    'ST': 'São Tomé & Príncipe',
    'SV': 'El Salvador',
    'SX': 'Sint Maarten',
    'SY': 'Syria',
    'SZ': 'Swaziland',
    'TA': 'Tristan da Cunha',
    'TC': 'Turks & Caicos Islands',
    'TD': 'Chad',
    'TF': 'French Southern Territories',
    'TG': 'Togo',
    'TH': 'Thailand',
    'TJ': 'Tajikistan',
    'TK': 'Tokelau',
    'TL': 'Timor-Leste',
    'TM': 'Turkmenistan',
    'TN': 'Tunisia',
    'TO': 'Tonga',
    'TR': 'Turkey',
    'TT': 'Trinidad & Tobago',
    'TV': 'Tuvalu',
    'TW': 'Taiwan',
    'TZ': 'Tanzania',
    'UA': 'Ukraine',
    'UG': 'Uganda',
    'UM': 'U.S. Outlying Islands',
    'UN': 'United Nations',
    'US': 'United States',
    'UY': 'Uruguay',
    'UZ': 'Uzbekistan',
    'VA': 'Vatican City',
    'VC': 'St. Vincent & Grenadines',
    'VE': 'Venezuela',
    'VG': 'British Virgin Islands',
    'VI': 'U.S. Virgin Islands',
    'VN': 'Vietnam',
    'VU': 'Vanuatu',
    'WF': 'Wallis & Futuna',
    'WS': 'Samoa',
    'XK': 'Kosovo',
    'YE': 'Yemen',
    'YT': 'Mayotte',
    'ZA': 'South Africa',
    'ZM': 'Zambia',
    'ZW': 'Zimbabwe',
    'ZZ': 'Unknown Region'
  },
  'LANGUAGE': {
    'aa': 'Afar',
    'ab': 'Abkhazian',
    'ace': 'Achinese',
    'ach': 'Acoli',
    'ada': 'Adangme',
    'ady': 'Adyghe',
    'ae': 'Avestan',
    'af': 'Afrikaans',
    'afh': 'Afrihili',
    'agq': 'Aghem',
    'ain': 'Ainu',
    'ak': 'Akan',
    'akk': 'Akkadian',
    'ale': 'Aleut',
    'alt': 'Southern Altai',
    'am': 'Amharic',
    'an': 'Aragonese',
    'ang': 'Old English',
    'anp': 'Angika',
    'ar': 'Arabic',
    'ar_001': 'Arabic (World)',
    'arc': 'Aramaic',
    'arn': 'Mapuche',
    'arp': 'Arapaho',
    'ars': 'Najdi Arabic',
    'arw': 'Arawak',
    'as': 'Assamese',
    'asa': 'Asu',
    'ast': 'Asturian',
    'av': 'Avaric',
    'awa': 'Awadhi',
    'ay': 'Aymara',
    'az': 'Azerbaijani',
    'az_Cyrl': 'Azerbaijani (Cyrillic)',
    'az_Latn': 'Azerbaijani (Latin)',
    'ba': 'Bashkir',
    'bal': 'Baluchi',
    'ban': 'Balinese',
    'bas': 'Basaa',
    'bax': 'Bamun',
    'bbj': 'Ghomala',
    'be': 'Belarusian',
    'bej': 'Beja',
    'bem': 'Bemba',
    'bez': 'Bena',
    'bfd': 'Bafut',
    'bg': 'Bulgarian',
    'bho': 'Bhojpuri',
    'bi': 'Bislama',
    'bik': 'Bikol',
    'bin': 'Bini',
    'bkm': 'Kom',
    'bla': 'Siksika',
    'bm': 'Bambara',
    'bn': 'Bangla',
    'bo': 'Tibetan',
    'br': 'Breton',
    'bra': 'Braj',
    'brx': 'Bodo',
    'bs': 'Bosnian',
    'bs_Cyrl': 'Bosnian (Cyrillic)',
    'bs_Latn': 'Bosnian (Latin)',
    'bss': 'Akoose',
    'bua': 'Buriat',
    'bug': 'Buginese',
    'bum': 'Bulu',
    'byn': 'Blin',
    'byv': 'Medumba',
    'ca': 'Catalan',
    'cad': 'Caddo',
    'car': 'Carib',
    'cay': 'Cayuga',
    'cch': 'Atsam',
    'ccp': 'Chakma',
    'ce': 'Chechen',
    'ceb': 'Cebuano',
    'cgg': 'Chiga',
    'ch': 'Chamorro',
    'chb': 'Chibcha',
    'chg': 'Chagatai',
    'chk': 'Chuukese',
    'chm': 'Mari',
    'chn': 'Chinook Jargon',
    'cho': 'Choctaw',
    'chp': 'Chipewyan',
    'chr': 'Cherokee',
    'chy': 'Cheyenne',
    'ckb': 'Central Kurdish',
    'co': 'Corsican',
    'cop': 'Coptic',
    'cr': 'Cree',
    'crh': 'Crimean Turkish',
    'cs': 'Czech',
    'csb': 'Kashubian',
    'cu': 'Church Slavic',
    'cv': 'Chuvash',
    'cy': 'Welsh',
    'da': 'Danish',
    'dak': 'Dakota',
    'dar': 'Dargwa',
    'dav': 'Taita',
    'de': 'German',
    'de_AT': 'German (Austria)',
    'de_CH': 'German (Switzerland)',
    'del': 'Delaware',
    'den': 'Slave',
    'dgr': 'Dogrib',
    'din': 'Dinka',
    'dje': 'Zarma',
    'doi': 'Dogri',
    'dsb': 'Lower Sorbian',
    'dua': 'Duala',
    'dum': 'Middle Dutch',
    'dv': 'Divehi',
    'dyo': 'Jola-Fonyi',
    'dyu': 'Dyula',
    'dz': 'Dzongkha',
    'dzg': 'Dazaga',
    'ebu': 'Embu',
    'ee': 'Ewe',
    'efi': 'Efik',
    'egy': 'Ancient Egyptian',
    'eka': 'Ekajuk',
    'el': 'Greek',
    'elx': 'Elamite',
    'en': 'English',
    'en_AU': 'English (Australia)',
    'en_CA': 'English (Canada)',
    'en_GB': 'English (United Kingdom)',
    'en_US': 'English (United States)',
    'enm': 'Middle English',
    'eo': 'Esperanto',
    'es': 'Spanish',
    'es_419': 'Spanish (Latin America)',
    'es_ES': 'Spanish (Spain)',
    'es_MX': 'Spanish (Mexico)',
    'et': 'Estonian',
    'eu': 'Basque',
    'ewo': 'Ewondo',
    'fa': 'Persian',
    'fa_AF': 'Persian (Afghanistan)',
    'fan': 'Fang',
    'fat': 'Fanti',
    'ff': 'Fulah',
    'fi': 'Finnish',
    'fil': 'Filipino',
    'fj': 'Fijian',
    'fo': 'Faroese',
    'fon': 'Fon',
    'fr': 'French',
    'fr_CA': 'French (Canada)',
    'fr_CH': 'French (Switzerland)',
    'frm': 'Middle French',
    'fro': 'Old French',
    'frr': 'Northern Frisian',
    'frs': 'Eastern Frisian',
    'fur': 'Friulian',
    'fy': 'Western Frisian',
    'ga': 'Irish',
    'gaa': 'Ga',
    'gay': 'Gayo',
    'gba': 'Gbaya',
    'gd': 'Scottish Gaelic',
    'gez': 'Geez',
    'gil': 'Gilbertese',
    'gl': 'Galician',
    'gmh': 'Middle High German',
    'gn': 'Guarani',
    'goh': 'Old High German',
    'gon': 'Gondi',
    'gor': 'Gorontalo',
    'got': 'Gothic',
    'grb': 'Grebo',
    'grc': 'Ancient Greek',
    'gsw': 'Swiss German',
    'gu': 'Gujarati',
    'guz': 'Gusii',
    'gv': 'Manx',
    'gwi': 'Gwichʼin',
    'ha': 'Hausa',
    'hai': 'Haida',
    'haw': 'Hawaiian',
    'he': 'Hebrew',
    'hi': 'Hindi',
    'hil': 'Hiligaynon',
    'hit': 'Hittite',
    'hmn': 'Hmong',
    'ho': 'Hiri Motu',
    'hr': 'Croatian',
    'hsb': 'Upper Sorbian',
    'ht': 'Haitian Creole',
    'hu': 'Hungarian',
    'hup': 'Hupa',
    'hy': 'Armenian',
    'hz': 'Herero',
    'ia': 'Interlingua',
    'iba': 'Iban',
    'ibb': 'Ibibio',
    'id': 'Indonesian',
    'ie': 'Interlingue',
    'ig': 'Igbo',
    'ii': 'Sichuan Yi',
    'ik': 'Inupiaq',
    'ilo': 'Iloko',
    'in': 'Indonesian',
    'inh': 'Ingush',
    'io': 'Ido',
    'is': 'Icelandic',
    'it': 'Italian',
    'iu': 'Inuktitut',
    'iw': 'Hebrew',
    'ja': 'Japanese',
    'jbo': 'Lojban',
    'jgo': 'Ngomba',
    'jmc': 'Machame',
    'jpr': 'Judeo-Persian',
    'jrb': 'Judeo-Arabic',
    'jv': 'Javanese',
    'ka': 'Georgian',
    'kaa': 'Kara-Kalpak',
    'kab': 'Kabyle',
    'kac': 'Kachin',
    'kaj': 'Jju',
    'kam': 'Kamba',
    'kaw': 'Kawi',
    'kbd': 'Kabardian',
    'kbl': 'Kanembu',
    'kcg': 'Tyap',
    'kde': 'Makonde',
    'kea': 'Kabuverdianu',
    'kfo': 'Koro',
    'kg': 'Kongo',
    'kha': 'Khasi',
    'kho': 'Khotanese',
    'khq': 'Koyra Chiini',
    'ki': 'Kikuyu',
    'kj': 'Kuanyama',
    'kk': 'Kazakh',
    'kkj': 'Kako',
    'kl': 'Kalaallisut',
    'kln': 'Kalenjin',
    'km': 'Khmer',
    'kmb': 'Kimbundu',
    'kn': 'Kannada',
    'ko': 'Korean',
    'kok': 'Konkani',
    'kos': 'Kosraean',
    'kpe': 'Kpelle',
    'kr': 'Kanuri',
    'krc': 'Karachay-Balkar',
    'krl': 'Karelian',
    'kru': 'Kurukh',
    'ks': 'Kashmiri',
    'ksb': 'Shambala',
    'ksf': 'Bafia',
    'ksh': 'Colognian',
    'ku': 'Kurdish',
    'kum': 'Kumyk',
    'kut': 'Kutenai',
    'kv': 'Komi',
    'kw': 'Cornish',
    'ky': 'Kyrgyz',
    'la': 'Latin',
    'lad': 'Ladino',
    'lag': 'Langi',
    'lah': 'Lahnda',
    'lam': 'Lamba',
    'lb': 'Luxembourgish',
    'lez': 'Lezghian',
    'lg': 'Ganda',
    'li': 'Limburgish',
    'lkt': 'Lakota',
    'ln': 'Lingala',
    'lo': 'Lao',
    'lol': 'Mongo',
    'loz': 'Lozi',
    'lrc': 'Northern Luri',
    'lt': 'Lithuanian',
    'lu': 'Luba-Katanga',
    'lua': 'Luba-Lulua',
    'lui': 'Luiseno',
    'lun': 'Lunda',
    'luo': 'Luo',
    'lus': 'Mizo',
    'luy': 'Luyia',
    'lv': 'Latvian',
    'mad': 'Madurese',
    'maf': 'Mafa',
    'mag': 'Magahi',
    'mai': 'Maithili',
    'mak': 'Makasar',
    'man': 'Mandingo',
    'mas': 'Masai',
    'mde': 'Maba',
    'mdf': 'Moksha',
    'mdr': 'Mandar',
    'men': 'Mende',
    'mer': 'Meru',
    'mfe': 'Morisyen',
    'mg': 'Malagasy',
    'mga': 'Middle Irish',
    'mgh': 'Makhuwa-Meetto',
    'mgo': 'Metaʼ',
    'mh': 'Marshallese',
    'mi': 'Maori',
    'mic': 'Mi\'kmaq',
    'min': 'Minangkabau',
    'mk': 'Macedonian',
    'ml': 'Malayalam',
    'mn': 'Mongolian',
    'mnc': 'Manchu',
    'mni': 'Manipuri',
    'mo': 'Romanian (Moldova)',
    'moh': 'Mohawk',
    'mos': 'Mossi',
    'mr': 'Marathi',
    'ms': 'Malay',
    'mt': 'Maltese',
    'mua': 'Mundang',
    'mul': 'Multiple languages',
    'mus': 'Creek',
    'mwl': 'Mirandese',
    'mwr': 'Marwari',
    'my': 'Burmese',
    'mye': 'Myene',
    'myv': 'Erzya',
    'mzn': 'Mazanderani',
    'na': 'Nauru',
    'nap': 'Neapolitan',
    'naq': 'Nama',
    'nb': 'Norwegian Bokmål',
    'nd': 'North Ndebele',
    'nds': 'Low German',
    'nds_NL': 'Low German (Netherlands)',
    'ne': 'Nepali',
    'new': 'Newari',
    'ng': 'Ndonga',
    'nia': 'Nias',
    'niu': 'Niuean',
    'nl': 'Dutch',
    'nl_BE': 'Dutch (Belgium)',
    'nmg': 'Kwasio',
    'nn': 'Norwegian Nynorsk',
    'nnh': 'Ngiemboon',
    'no': 'Norwegian',
    'nog': 'Nogai',
    'non': 'Old Norse',
    'nqo': 'N’Ko',
    'nr': 'South Ndebele',
    'nso': 'Northern Sotho',
    'nus': 'Nuer',
    'nv': 'Navajo',
    'nwc': 'Classical Newari',
    'ny': 'Nyanja',
    'nym': 'Nyamwezi',
    'nyn': 'Nyankole',
    'nyo': 'Nyoro',
    'nzi': 'Nzima',
    'oc': 'Occitan',
    'oj': 'Ojibwa',
    'om': 'Oromo',
    'or': 'Odia',
    'os': 'Ossetic',
    'osa': 'Osage',
    'ota': 'Ottoman Turkish',
    'pa': 'Punjabi',
    'pa_Arab': 'Punjabi (Arabic)',
    'pa_Guru': 'Punjabi (Gurmukhi)',
    'pag': 'Pangasinan',
    'pal': 'Pahlavi',
    'pam': 'Pampanga',
    'pap': 'Papiamento',
    'pau': 'Palauan',
    'peo': 'Old Persian',
    'phn': 'Phoenician',
    'pi': 'Pali',
    'pl': 'Polish',
    'pon': 'Pohnpeian',
    'pro': 'Old Provençal',
    'ps': 'Pashto',
    'pt': 'Portuguese',
    'pt_BR': 'Portuguese (Brazil)',
    'pt_PT': 'Portuguese (Portugal)',
    'qu': 'Quechua',
    'raj': 'Rajasthani',
    'rap': 'Rapanui',
    'rar': 'Rarotongan',
    'rm': 'Romansh',
    'rn': 'Rundi',
    'ro': 'Romanian',
    'ro_MD': 'Romanian (Moldova)',
    'rof': 'Rombo',
    'rom': 'Romany',
    'ru': 'Russian',
    'rup': 'Aromanian',
    'rw': 'Kinyarwanda',
    'rwk': 'Rwa',
    'sa': 'Sanskrit',
    'sad': 'Sandawe',
    'sah': 'Sakha',
    'sam': 'Samaritan Aramaic',
    'saq': 'Samburu',
    'sas': 'Sasak',
    'sat': 'Santali',
    'sba': 'Ngambay',
    'sbp': 'Sangu',
    'sc': 'Sardinian',
    'scn': 'Sicilian',
    'sco': 'Scots',
    'sd': 'Sindhi',
    'se': 'Northern Sami',
    'see': 'Seneca',
    'seh': 'Sena',
    'sel': 'Selkup',
    'ses': 'Koyraboro Senni',
    'sg': 'Sango',
    'sga': 'Old Irish',
    'sh': 'Serbo-Croatian',
    'shi': 'Tachelhit',
    'shi_Latn': 'Tachelhit (Latin)',
    'shi_Tfng': 'Tachelhit (Tifinagh)',
    'shn': 'Shan',
    'shu': 'Chadian Arabic',
    'si': 'Sinhala',
    'sid': 'Sidamo',
    'sk': 'Slovak',
    'sl': 'Slovenian',
    'sm': 'Samoan',
    'sma': 'Southern Sami',
    'smj': 'Lule Sami',
    'smn': 'Inari Sami',
    'sms': 'Skolt Sami',
    'sn': 'Shona',
    'snk': 'Soninke',
    'so': 'Somali',
    'sog': 'Sogdien',
    'sq': 'Albanian',
    'sr': 'Serbian',
    'sr_Cyrl': 'Serbian (Cyrillic)',
    'sr_Latn': 'Serbian (Latin)',
    'srn': 'Sranan Tongo',
    'srr': 'Serer',
    'ss': 'Swati',
    'ssy': 'Saho',
    'st': 'Southern Sotho',
    'su': 'Sundanese',
    'suk': 'Sukuma',
    'sus': 'Susu',
    'sux': 'Sumerian',
    'sv': 'Swedish',
    'sw': 'Swahili',
    'sw_CD': 'Swahili (Congo - Kinshasa)',
    'swb': 'Comorian',
    'syc': 'Classical Syriac',
    'syr': 'Syriac',
    'ta': 'Tamil',
    'te': 'Telugu',
    'tem': 'Timne',
    'teo': 'Teso',
    'ter': 'Tereno',
    'tet': 'Tetum',
    'tg': 'Tajik',
    'th': 'Thai',
    'ti': 'Tigrinya',
    'tig': 'Tigre',
    'tiv': 'Tiv',
    'tk': 'Turkmen',
    'tkl': 'Tokelau',
    'tl': 'Tagalog',
    'tlh': 'Klingon',
    'tli': 'Tlingit',
    'tmh': 'Tamashek',
    'tn': 'Tswana',
    'to': 'Tongan',
    'tog': 'Nyasa Tonga',
    'tpi': 'Tok Pisin',
    'tr': 'Turkish',
    'trv': 'Taroko',
    'ts': 'Tsonga',
    'tsi': 'Tsimshian',
    'tt': 'Tatar',
    'tum': 'Tumbuka',
    'tvl': 'Tuvalu',
    'tw': 'Twi',
    'twq': 'Tasawaq',
    'ty': 'Tahitian',
    'tyv': 'Tuvinian',
    'tzm': 'Central Atlas Tamazight',
    'udm': 'Udmurt',
    'ug': 'Uyghur',
    'uga': 'Ugaritic',
    'uk': 'Ukrainian',
    'umb': 'Umbundu',
    'und': 'Unknown language',
    'ur': 'Urdu',
    'uz': 'Uzbek',
    'uz_Arab': 'Uzbek (Arabic)',
    'uz_Cyrl': 'Uzbek (Cyrillic)',
    'uz_Latn': 'Uzbek (Latin)',
    'vai': 'Vai',
    'vai_Latn': 'Vai (Latin)',
    'vai_Vaii': 'Vai (Vai)',
    've': 'Venda',
    'vi': 'Vietnamese',
    'vo': 'Volapük',
    'vot': 'Votic',
    'vun': 'Vunjo',
    'wa': 'Walloon',
    'wae': 'Walser',
    'wal': 'Wolaytta',
    'war': 'Waray',
    'was': 'Washo',
    'wo': 'Wolof',
    'xal': 'Kalmyk',
    'xh': 'Xhosa',
    'xog': 'Soga',
    'yao': 'Yao',
    'yap': 'Yapese',
    'yav': 'Yangben',
    'ybb': 'Yemba',
    'yi': 'Yiddish',
    'yo': 'Yoruba',
    'yue': 'Cantonese',
    'yue_Hans': 'Cantonese (Simplified)',
    'yue_Hant': 'Cantonese (Traditional)',
    'za': 'Zhuang',
    'zap': 'Zapotec',
    'zbl': 'Blissymbols',
    'zen': 'Zenaga',
    'zgh': 'Standard Moroccan Tamazight',
    'zh': 'Chinese',
    'zh_Hans': 'Chinese (Simplified)',
    'zh_Hant': 'Chinese (Traditional)',
    'zh_TW': 'Chinese (Taiwan)',
    'zu': 'Zulu',
    'zun': 'Zuni',
    'zxx': 'No linguistic content',
    'zza': 'Zaza'
  }
};
