/*  Zutils - Utilities dealing with compressed files
    Copyright (C) 2009-2014 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

enum { fmt_bz2, fmt_gz, fmt_lz, fmt_xz, num_formats };
const char * const format_names[num_formats] = { "bz2", "gz", "lz", "xz" };
const char * const simple_extensions[num_formats] =
  { ".bz2", ".gz", ".lz", ".xz" };
const int format_order[num_formats] =
  { fmt_lz, fmt_bz2, fmt_gz, fmt_xz };		// search order

extern const char * invocation_name;
extern const char * program_name;
extern int verbosity;

class Arg_parser;

void maybe_process_config_file( const Arg_parser & parser );

void parse_compressor( const std::string & arg, const int format_index,
                       const int eretval = 2 );

const char * get_compressor_name( const int format_index );
const std::vector< std::string > & get_compressor_args( const int format_index );

void show_help_addr();
void show_version();
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false );
void show_error2( const char * const msg, const char * const name );
void internal_error( const char * const msg );
void show_close_error( const char * const prog_name = "data feeder" );
void show_exec_error( const char * const prog_name );
void show_fork_error( const char * const prog_name );

// Returns exit status of child process 'pid', or 'eretval' in case of error.
//
int wait_for_child( const pid_t pid, const char * const name,
                    const int eretval = 2, const bool isgzxz = false );
