/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.tasks.state.DNSStateTask;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextUpdateTest {
    private ServiceInfo service;
    private ServiceInfo printer;
    private MockListener serviceListenerMock;
    private static final String serviceKey = "srvname";

    @Before
    public void setup() {
        Object object;
        Object object2;
        boolean bl = false;
        if (bl) {
            object2 = new ConsoleHandler();
            ((Handler)object2).setLevel(Level.FINEST);
            object = LogManager.getLogManager().getLoggerNames();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Logger logger = Logger.getLogger(string);
                logger.addHandler((Handler)object2);
                logger.setLevel(Level.FINEST);
            }
        }
        object2 = "Test hypothetical web server";
        object = new HashMap<String, byte[]>();
        object.put(serviceKey, ((String)object2).getBytes());
        this.service = ServiceInfo.create("_html._tcp.local.", "apache-someuniqueid", 80, 0, 0, true, object);
        object2 = "Test hypothetical print server";
        object.clear();
        object.put(serviceKey, ((String)object2).getBytes());
        this.printer = ServiceInfo.create("_html._tcp.local.", "printer-someuniqueid", "_printer", 80, 0, 0, true, object);
        this.serviceListenerMock = new MockListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListenForTextUpdateOnOtherRegistry() throws IOException, InterruptedException {
        JmDNS jmDNS = null;
        Closeable closeable = null;
        try {
            jmDNS = JmDNS.create("Listener");
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            closeable = JmDNS.create("Registry");
            ((JmDNS)closeable).registerService(this.service);
            List<ServiceEvent> list = this.serviceListenerMock.servicesAdded();
            Assert.assertEquals((String)"We did not get the service added event.", (int)1, (int)list.size());
            ServiceInfo serviceInfo = list.get(list.size() - 1).getInfo();
            Assert.assertEquals((String)"We did not get the right name for the resolved service:", (String)this.service.getName(), (String)serviceInfo.getName());
            Assert.assertEquals((String)"We did not get the right type for the resolved service:", (String)this.service.getType(), (String)serviceInfo.getType());
            List<ServiceEvent> list2 = this.serviceListenerMock.servicesResolved();
            Assert.assertEquals((String)"We did not get the service resolved event.", (int)1, (int)list2.size());
            ServiceInfo serviceInfo2 = list2.get(list2.size() - 1).getInfo();
            Assert.assertNotNull((String)"Did not get the expected service info: ", (Object)serviceInfo2);
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.service, (Object)serviceInfo2);
            Assert.assertEquals((String)"Did not get the expected service info text: ", (String)this.service.getPropertyString(serviceKey), (String)serviceInfo2.getPropertyString(serviceKey));
            this.serviceListenerMock.reset();
            String string = "Test improbable web server";
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put(serviceKey, string.getBytes());
            this.service.setText(hashMap);
            Thread.sleep(3000L);
            list2 = this.serviceListenerMock.servicesResolved();
            Assert.assertEquals((String)"We did not get the service text updated event.", (int)1, (int)list2.size());
            serviceInfo2 = list2.get(list2.size() - 1).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info text: ", (String)string, (String)serviceInfo2.getPropertyString(serviceKey));
            this.serviceListenerMock.reset();
            string = "Test more improbable web server";
            hashMap = new HashMap();
            hashMap.put(serviceKey, string.getBytes());
            this.service.setText(hashMap);
            Thread.sleep(3000L);
            list2 = this.serviceListenerMock.servicesResolved();
            Assert.assertEquals((String)"We did not get the service text updated event.", (int)1, (int)list2.size());
            serviceInfo2 = list2.get(list2.size() - 1).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info text: ", (String)string, (String)serviceInfo2.getPropertyString(serviceKey));
            this.serviceListenerMock.reset();
            string = "Test even more improbable web server";
            hashMap = new HashMap();
            hashMap.put(serviceKey, string.getBytes());
            this.service.setText(hashMap);
            Thread.sleep(3000L);
            list2 = this.serviceListenerMock.servicesResolved();
            Assert.assertEquals((String)"We did not get the service text updated event.", (int)1, (int)list2.size());
            serviceInfo2 = list2.get(list2.size() - 1).getInfo();
            Assert.assertEquals((String)"Did not get the expected service info text: ", (String)string, (String)serviceInfo2.getPropertyString(serviceKey));
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (closeable != null) {
                closeable.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenewExpiringRequests() throws IOException, InterruptedException {
        JmDNS jmDNS = null;
        Closeable closeable = null;
        try {
            DNSStateTask.setDefaultTTL(60);
            jmDNS = JmDNS.create("Listener");
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            closeable = JmDNS.create("Registry");
            ((JmDNS)closeable).registerService(this.service);
            List<ServiceEvent> list = this.serviceListenerMock.servicesAdded();
            Assert.assertTrue((String)"We did not get the service added event.", (list.size() == 1 ? 1 : 0) != 0);
            ServiceInfo[] serviceInfoArray = jmDNS.list(this.service.getType());
            Assert.assertEquals((String)"We should see the service we just registered: ", (int)1, (int)serviceInfoArray.length);
            Assert.assertEquals((Object)this.service, (Object)serviceInfoArray[0]);
            Thread.sleep(120000L);
            serviceInfoArray = jmDNS.list(this.service.getType());
            Assert.assertEquals((String)"We should see the service after the renewal: ", (int)1, (int)serviceInfoArray.length);
            Assert.assertEquals((Object)this.service, (Object)serviceInfoArray[0]);
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (closeable != null) {
                closeable.close();
            }
            DNSStateTask.setDefaultTTL(3600);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubtype() throws IOException {
        JmDNS jmDNS = null;
        Closeable closeable = null;
        try {
            jmDNS = JmDNS.create("Listener");
            jmDNS.addServiceListener(this.service.getType(), this.serviceListenerMock);
            closeable = JmDNS.create("Registry");
            ((JmDNS)closeable).registerService(this.printer);
            List<ServiceEvent> list = this.serviceListenerMock.servicesAdded();
            Assert.assertEquals((String)"We did not get the service added event.", (int)1, (int)list.size());
            ServiceInfo serviceInfo = list.get(list.size() - 1).getInfo();
            Assert.assertEquals((String)"We did not get the right name for the resolved service:", (String)this.printer.getName(), (String)serviceInfo.getName());
            Assert.assertEquals((String)"We did not get the right type for the resolved service:", (String)this.printer.getType(), (String)serviceInfo.getType());
            List<ServiceEvent> list2 = this.serviceListenerMock.servicesResolved();
            Assert.assertEquals((String)"We did not get the service resolved event.", (int)1, (int)list2.size());
            ServiceInfo serviceInfo2 = list2.get(list2.size() - 1).getInfo();
            Assert.assertNotNull((String)"Did not get the expected service info: ", (Object)serviceInfo2);
            Assert.assertEquals((String)"Did not get the expected service info: ", (Object)this.printer, (Object)serviceInfo2);
            Assert.assertEquals((String)"Did not get the expected service info subtype: ", (String)this.printer.getSubtype(), (String)serviceInfo2.getSubtype());
            Assert.assertEquals((String)"Did not get the expected service info text: ", (String)this.printer.getPropertyString(serviceKey), (String)serviceInfo2.getPropertyString(serviceKey));
            this.serviceListenerMock.reset();
        }
        finally {
            if (jmDNS != null) {
                jmDNS.close();
            }
            if (closeable != null) {
                closeable.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MockListener
    implements ServiceListener {
        private final List<ServiceEvent> _serviceAdded = Collections.synchronizedList(new ArrayList(2));
        private final List<ServiceEvent> _serviceRemoved = Collections.synchronizedList(new ArrayList(2));
        private final List<ServiceEvent> _serviceResolved = Collections.synchronizedList(new ArrayList(2));

        @Override
        public void serviceAdded(ServiceEvent serviceEvent) {
            try {
                this._serviceAdded.add((ServiceEvent)serviceEvent.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        public void serviceRemoved(ServiceEvent serviceEvent) {
            try {
                this._serviceRemoved.add((ServiceEvent)serviceEvent.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        public void serviceResolved(ServiceEvent serviceEvent) {
            try {
                this._serviceResolved.add((ServiceEvent)serviceEvent.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        public List<ServiceEvent> servicesAdded() {
            return this._serviceAdded;
        }

        public List<ServiceEvent> servicesRemoved() {
            return this._serviceRemoved;
        }

        public List<ServiceEvent> servicesResolved() {
            return this._serviceResolved;
        }

        public synchronized void reset() {
            this._serviceAdded.clear();
            this._serviceRemoved.clear();
            this._serviceResolved.clear();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Services Added: " + this._serviceAdded.size());
            for (ServiceEvent serviceEvent : this._serviceAdded) {
                stringBuilder.append("\n\tevent name: '");
                stringBuilder.append(serviceEvent.getName());
                stringBuilder.append("' type: '");
                stringBuilder.append(serviceEvent.getType());
                stringBuilder.append("' info: '");
                stringBuilder.append(serviceEvent.getInfo());
            }
            stringBuilder.append("\nServices Removed: " + this._serviceRemoved.size());
            for (ServiceEvent serviceEvent : this._serviceRemoved) {
                stringBuilder.append("\n\tevent name: '");
                stringBuilder.append(serviceEvent.getName());
                stringBuilder.append("' type: '");
                stringBuilder.append(serviceEvent.getType());
                stringBuilder.append("' info: '");
                stringBuilder.append(serviceEvent.getInfo());
            }
            stringBuilder.append("\nServices Resolved: " + this._serviceResolved.size());
            for (ServiceEvent serviceEvent : this._serviceResolved) {
                stringBuilder.append("\n\tevent name: '");
                stringBuilder.append(serviceEvent.getName());
                stringBuilder.append("' type: '");
                stringBuilder.append(serviceEvent.getType());
                stringBuilder.append("' info: '");
                stringBuilder.append(serviceEvent.getInfo());
            }
            return stringBuilder.toString();
        }
    }
}

