#include <X11/Xlib.h>

static char s1_bits[] = {0x02, 0x01};
static char s2_bits[] = {0x09, 0x0c, 0x06, 0x03};
static char s3_bits[] = {0x23, 0x31, 0x38, 0x1c, 0x0e, 0x07};
static char s4_bits[] = {
   	0x87, 0xc3, 0xe1, 0xf0, 0x78, 0x3c, 0x1e, 0x0f};
static char s5_bits[] = {
   0x0f, 0x02, 0x07, 0x03, 0x83, 0x03, 0xc1, 0x03, 0xe0, 0x03, 0xf0, 0x01,
   0xf8, 0x00, 0x7c, 0x00, 0x3e, 0x00, 0x1f, 0x00};
static unsigned char s6_bits[] = {
   0x1f, 0x08, 0x0f, 0x0c, 0x07, 0x0e, 0x03, 0x0f, 0x81, 0x0f, 0xc0, 0x0f,
   0xe0, 0x07, 0xf0, 0x03, 0xf8, 0x01, 0xfc, 0x00, 0x7e, 0x00, 0x3f, 0x00};
static unsigned char s7_bits[] = {
   0x3f, 0x20, 0x1f, 0x30, 0x0f, 0x38, 0x07, 0x3c, 0x03, 0x3e, 0x01, 0x3f,
   0x80, 0x3f, 0xc0, 0x1f, 0xe0, 0x0f, 0xf0, 0x07, 0xf8, 0x03, 0xfc, 0x01,
   0xfe, 0x00, 0x7f, 0x00};
static unsigned char s8_bits[] = {
   0x7f, 0x80, 0x3f, 0xc0, 0x1f, 0xe0, 0x0f, 0xf0, 0x07, 0xf8, 0x03, 0xfc,
   0x01, 0xfe, 0x00, 0xff, 0x80, 0x7f, 0xc0, 0x3f, 0xe0, 0x1f, 0xf0, 0x0f,
   0xf8, 0x07, 0xfc, 0x03, 0xfe, 0x01, 0xff, 0x00};
static unsigned char s9_bits[] = {
   0xff, 0x00, 0x02, 0x7f, 0x00, 0x03, 0x3f, 0x80, 0x03, 0x1f, 0xc0, 0x03,
   0x0f, 0xe0, 0x03, 0x07, 0xf0, 0x03, 0x03, 0xf8, 0x03, 0x01, 0xfc, 0x03,
   0x00, 0xfe, 0x03, 0x00, 0xff, 0x01, 0x80, 0xff, 0x00, 0xc0, 0x7f, 0x00,
   0xe0, 0x3f, 0x00, 0xf0, 0x1f, 0x00, 0xf8, 0x0f, 0x00, 0xfc, 0x07, 0x00,
   0xfe, 0x03, 0x00, 0xff, 0x01, 0x00};
static unsigned char s10_bits[] = {
   0xff, 0x01, 0x08, 0xff, 0x00, 0x0c, 0x7f, 0x00, 0x0e, 0x3f, 0x00, 0x0f,
   0x1f, 0x80, 0x0f, 0x0f, 0xc0, 0x0f, 0x07, 0xe0, 0x0f, 0x03, 0xf0, 0x0f,
   0x01, 0xf8, 0x0f, 0x00, 0xfc, 0x0f, 0x00, 0xfe, 0x07, 0x00, 0xff, 0x03,
   0x80, 0xff, 0x01, 0xc0, 0xff, 0x00, 0xe0, 0x7f, 0x00, 0xf0, 0x3f, 0x00,
   0xf8, 0x1f, 0x00, 0xfc, 0x0f, 0x00, 0xfe, 0x07, 0x00, 0xff, 0x03, 0x00};
static unsigned char s11_bits[] = {
   0xff, 0x03, 0x20, 0xff, 0x01, 0x30, 0xff, 0x00, 0x38, 0x7f, 0x00, 0x3c,
   0x3f, 0x00, 0x3e, 0x1f, 0x00, 0x3f, 0x0f, 0x80, 0x3f, 0x07, 0xc0, 0x3f,
   0x03, 0xe0, 0x3f, 0x01, 0xf0, 0x3f, 0x00, 0xf8, 0x3f, 0x00, 0xfc, 0x1f,
   0x00, 0xfe, 0x0f, 0x00, 0xff, 0x07, 0x80, 0xff, 0x03, 0xc0, 0xff, 0x01,
   0xe0, 0xff, 0x00, 0xf0, 0x7f, 0x00, 0xf8, 0x3f, 0x00, 0xfc, 0x1f, 0x00,
   0xfe, 0x0f, 0x00, 0xff, 0x07, 0x00};


extern Display *TDisplay;
extern Window TWindow;
static Pixmap Stipples[20];

#define BITMAX 11
int maxlwidth = BITMAX;

static char *bits(int lw)
{
	switch (lw) {
		case 1: return s1_bits;
		case 2: return s2_bits;
		case 3: return s3_bits;
		case 4: return s4_bits;
		case 5: return s5_bits;
		case 6: return s6_bits;
		case 7: return s7_bits;
		case 8: return s8_bits;
		case 9: return s9_bits;
		case 10: return s10_bits;
		case 11: return s11_bits;
		default: return s11_bits;
	}
}

static void CreateStipple(int lw)
{
	Stipples[lw - 1] = XCreatePixmapFromBitmapData(
		TDisplay,TWindow, 
		bits(lw),
		lw * 2, lw * 2,
		1,0,1);
}

Pixmap GetStipple(int lw)
{
	int ret = lw;
	if (lw < 1) ret = 1;
	if (lw > BITMAX) ret = BITMAX;
	if (Stipples[ret - 1] == 0) /* only create what we need */
		CreateStipple(ret);
	return Stipples[ret - 1];
}
