/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_tr_file.c,v 1.2 1999/11/08 06:20:26 bbarrett Exp $
 *
 *	Function:	- select a trace file
 */

#include <stdio.h>
#include <string.h>

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "xmpi.h"

/*
 * global functions
 */
void			xmpi_tr_file();

/*
 * local functions
 */
static void		parse();

/*
 * external variables
 */
extern char		tracefile[];		/* name of trace file */

/*
 * local variables
 */
static Widget		fsdialog = 0;		/* file selection dialog */

/*
 *	xmpi_tr_file
 *
 *	Function:	- selects trace file via a dialog and parses it
 *	Accepts:	- parent widget
 */
void
xmpi_tr_file(parent)

Widget			parent;

{
	Arg		args[2];
	XmString	oklabel;
	XmString	title;
	Widget		help_btn;

	if (fsdialog == 0) {
		title = XmStringCreateSimple("XMPI Trace Selection");
		oklabel = XmStringCreateSimple("View");

		XtSetArg(args[0], XmNdialogTitle, title);
		XtSetArg(args[1], XmNokLabelString, oklabel);
/*
 * The trace file extension is the "dirMask" resource and may be set
 * in the application defaults file.  It defaults to ".lamtr".
 */
		fsdialog = XmCreateFileSelectionDialog(parent,
				"trace_selector", args, 2);

		XtAddCallback(fsdialog, XmNokCallback, parse, NULL);
		XtAddCallback(fsdialog, XmNcancelCallback,
				(XtCallbackProc) XtUnmanageChild, NULL);

		help_btn = XmFileSelectionBoxGetChild(fsdialog,
				XmDIALOG_HELP_BUTTON);
		XtUnmanageChild(help_btn);

		XmStringFree(title);
		XmStringFree(oklabel);
	}
	else {
		XmFileSelectionDoSearch(fsdialog, 0);
	}

	XtManageChild(fsdialog);
}

/*
 *	parse
 *
 *	Function:	- parse selected trace file (OK callback)
 *	Accepts:	- callback data
 */
static void
parse(w, data, cbs)

Widget			w;
caddr_t			data;
XmFileSelectionBoxCallbackStruct
			*cbs;

{
	char		*name;			/* file name */
	FILE		*trfs;			/* trace file stream */
	
	if (XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &name))
		strncpy(tracefile, name, XMPI_PATHMAX);

	XtFree(name);

	trfs = fopen(tracefile, "r");

	if (trfs == 0) {
		xmpi_error(0, tracefile);
	} else {
		XtUnmanageChild(w);
		xmpi_parse_tracefile(trfs);
	}
}
