/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_help.c,v 1.3 1999/11/08 06:20:24 bbarrett Exp $
 * 
 *	Function:	- XMPI help
 */

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "args.h"
#include "xmpi.h"

/*
 * public functions
 */
void 			xmpi_help();

/*
 * private functions
 */
static void		childtrap();

/*
 * private variables
 */
static int		help_pid = 0;

/*
 *	xmpi_help
 *
 *	Function:	- fork-exec help
 */
void
xmpi_help()

{
	char		errbuf[512];
	char		**argv;
	int		pid;
	struct sigaction
			chld;		/* SIGCHLD action */

	if (help_pid > 0) return;
	
	if (app_res.ap_helpcmd == 0 || strlen(app_res.ap_helpcmd) == 0) {
		return;
	}

	argv = argvbreak(app_res.ap_helpcmd, ' ');

	if (argv == 0) {
		xmpi_error(0, "xmpi_help (argvbreak)");
	} else {

		chld.sa_handler = childtrap;
		chld.sa_flags = SA_NOCLDSTOP;
		sigemptyset(&chld.sa_mask);
		sigaction(SIGCHLD, &chld, (struct sigaction *) 0);

		if ((pid = fork()) < 0) {
			xmpi_error(0, "xmpi_help (fork)");
		}
		else if (pid == 0) {		
			execvp(argv[0], argv);
			sprintf(errbuf, "xmpi: ERROR in help command \"%s\"",
				app_res.ap_helpcmd);
			perror(errbuf);
			exit(errno);
		} else {
			help_pid = pid;
		}
	}
}

/*
 *	childtrap
 *
 *	Function:	- traps child process termination
 */
static void
childtrap()

{
	int		status;

	if (help_pid > 0) {
		if (waitpid(help_pid, &status, WNOHANG) > 0) {
			help_pid = 0;
		}
	}
}
