
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "stdio.h"
#include "strings.h"
#include "string.h"
#include <unistd.h>

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdk.h>

#include "gtktopdata.h"

#include "gtk_subimagesel.h"

#include "main.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "gtk-extra.h"
#include "../libmorph/relax.h"


/************************************* making movies ******************/





void
on_morph_sequence1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{  
  static GtkWidget* m=NULL;
 if( sp->max_wins<=1)
    {
      show_warning( _("to morph, you must have at least two input images"));
      return;
    }
 else
   {
     if(m==NULL || !GTK_IS_WIDGET (m))
       m=create_window_movie();     
     gtk_widget_show(m);
   }
}



morph_factors_t morph_factors_saved[4];



void
store_morph_factors(int i)
{
  memcpy (& morph_factors_saved[i], &sp->mf,  sizeof(morph_factors_t));
}

void
restore_morph_factors(int i)
{
  memcpy(& sp->mf, &morph_factors_saved[i], sizeof(morph_factors_t));
  redraw_spins();
}

void (*action_morph_factors)(int i);

void
on_menumorphfactors_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char *n=gtk_widget_get_name(GTK_WIDGET(menuitem));
  g_assert(n);

  if(strcmp(n,"start"))
    (*action_morph_factors)(0);
  else if(strcmp(n,"end"))
    (*action_morph_factors)(1);
  else
    g_error(" unkown menu item ");
}



void
on_morph_factors_activate        (GtkMenuItem     *menuitem,
				  gpointer         user_data)
{
  static GtkWidget* m=NULL;
  if(m==NULL)
    m=create_menuMorphFactors();
    
  gtk_menu_popup (GTK_MENU(m),//GtkMenu *menu,
		  NULL,//GtkWidget *parent_menu_shell,
		  NULL,//GtkWidget *parent_menu_item,
		  NULL,//GtkMenuPositionFunc func,
		  NULL,//gpointer data,
		  1,//guint button,
		  0);//guint32 activate_time);
}

void
on_store_morph_factors_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  action_morph_factors=store_morph_factors;
  on_morph_factors_activate        (menuitem,user_data);
}


void
on_restore_morph_factors1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  action_morph_factors=restore_morph_factors;
  on_morph_factors_activate        (menuitem,user_data);
}


#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <errno.h>

void
movie_names(char *name[],char * basename, int first, int tot)
{
  int ima;
  for(ima=0; ima < tot; ima++) 
    name[ima]=g_strdup_printf("%s%0+3d.ppm",basename,ima+first);
}

void
movie_data( GtkButton       *button, int  *first, int *tot, char **basename)
{
  GtkWidget* m=NULL, 
    *widget=GTK_WIDGET(button);

  GtkSpinButton *spin;

  m=gtk_widget_get_data_top(widget,"file_base_name");
  g_assert(m);
  *basename=  gtk_entry_get_text(GTK_ENTRY(m));

  m=gtk_widget_get_data_top(widget,"spinbutton_first_file");
  g_assert(m);
  spin = GTK_SPIN_BUTTON (m);  
  *first=gtk_spin_button_get_value_as_float (spin);
  
  m=gtk_widget_get_data_top(widget,"spinbutton_n_files");
  g_assert(m);
  spin = GTK_SPIN_BUTTON (m);  
  *tot=gtk_spin_button_get_value_as_float (spin);

}
void
on_movie_ok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
 
  char * basename;
  int ima, lp, first, tot;

  movie_data( button, &first, &tot, &basename);
 
  {
    char *name[tot], 
      *err= g_strdup ("");

    movie_names(name,basename,  first, tot);

    {
      struct stat buf;
      for(ima=0; ima < tot; ima++) {
	if (0== stat (name[ima],&buf)) {
	  err=g_strdup_printf("%s\n %s ",err,name[ima]);
	//perror(name[ima]);
	}
      }
    }
    if( strlen(err) > 0) {
      err=g_strdup_printf("the following files already exist:\n%s",err);
      show_warning(err);
      g_free(err);
      for(ima=0; ima < tot; ima++)
	g_free(name[ima]);
      return ;      
    }
    g_free(err);    
  
    for(ima=0; ima < tot; ima++) {
      double a = (double)ima / ((double)tot-1.0),      b=1-a;
      for(lp=MAX_WINS; lp >=0; lp--) {
	sp->mf.im_warp_factor[lp]= 
	  morph_factors_saved[0].im_warp_factor[lp] * a +
	  morph_factors_saved[1].im_warp_factor[lp] * b;
	sp->mf.im_dissolve_factor[lp]= 
	  morph_factors_saved[0].im_dissolve_factor[lp] * a +
	  morph_factors_saved[1].im_dissolve_factor[lp] * b;
      }

      on_interpolate_meshes1_activate (NULL,NULL);

      redraw_spins();
      /* computation going on */
      while (gtk_events_pending())
	gtk_main_iteration();
      /* computation continued */
      
      on_morph_images1_activate( NULL, NULL);


      /* computation going on */
      while (gtk_events_pending())
	gtk_main_iteration();
      /* computation continued */
      
      save_image_to_file(MAX_WINS+1, name[ima]);
    }

    on_movie_replay_clicked(button, user_data);

    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
  }
}



void
on_movie_help_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{

  char * basename;
  int ima, first, tot;

  movie_data( button, &first, &tot, &basename);
  {
    char *name[tot], *help;
    movie_names(name,basename,  first, tot);
    
    help=g_strdup_printf("\
Help on movie making: when you hit ok, gtkmorph will repeat a loop for %d times.\n\
Any time, it will set the warping and image-blending factors to\n\
an interpolation between the values that you have stored as 'first' and 'end'.\n\
Any time, it will save the morphed image,\
 starting from '%s' and ending with '%s'.\n\
Then it will create any animation that you have asked to create:\n\
 the animated gif is called '%s.gif',\n\
 the mpeg file is called '%s.mpeg'\n\
  (and mpeg_encode will use '%s.param' for parameters if available)\n\
and play them.\n\
You may recreate animations from preexisting frames by hitting 'replay'\n\
", tot, name[0], name[tot-1] ,basename,basename,basename );
    show_warning(help);


    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
    g_free(help);
  }
}  


void
on_movie_replay_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  char * basename;
  int ima,  first, tot;

  movie_data( button, &first, &tot, &basename);

  {
    char *name[tot], 
      *cmd= g_strdup ("");
    char *names=g_strdup("");

    movie_names(name,basename,  first, tot);
    
    for(ima=0; ima < tot; ima++) 
      names=g_strdup_printf("%s '%s'",names,name[ima]);

    {
      GtkWidget *widget=GTK_WIDGET(button);

      GtkCheckButton *b;
      /******************** animate ******************/
      b=gtk_widget_get_data_top(widget,"animate");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {	
	cmd= g_strdup_printf ("animate -delay %d %s &",1+200/tot,names);  
	system(cmd);
	g_free(cmd);
      }

      /******************* gif *********************/
      b=gtk_widget_get_data_top(widget,"animated_gif");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {
	cmd= g_strdup_printf ("\
convert %s '%s.gif' && animate  -delay %d '%s.gif' &",
			      names,basename,
			      1+200/tot, basename);	
	system(cmd);
	g_free(cmd);
      }
      
      /***************** mpeg **********************/
      b=gtk_widget_get_data_top(widget,"animated_mpeg");
      g_assert(b);
      if(gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(b))) {
	char *tmpname=g_strdup_printf(".%s.mpeg.params.gtkmorph%d",
				      basename, getpid()),
	  *parmname=g_strdup_printf ("%s.param",basename);
	FILE *tmpfile=fopen(tmpname,"w"),
	  *parmfile;
	char *cmd= g_strdup_printf ("\
mpeg_encode -quiet 3 '%s' && mpeg_play -quiet '%s.mpeg'  &", tmpname,basename);
	if(tmpfile) {
	  fprintf(tmpfile,"\
OUTPUT %s.mpeg\n\
INPUT_DIR .\n\
INPUT\n",basename);
	  for(ima=0; ima < tot; ima++)
	    fprintf(tmpfile,"%s\n", name[ima]);
	  fprintf(tmpfile,"\
END_INPUT\n\
BASE_FILE_FORMAT PPM\n\
INPUT_CONVERT *\n");
	  parmfile=fopen(parmname,"r");
	  if( NULL!=  parmfile) {
	    char s[500];
	    while(!feof(parmfile)) {
	      fgets(s,500,parmfile);
	      fputs(s,tmpfile); }
	      fclose(parmfile);
	  } else {
	    int slices=10;
	    while ( slices >1 && ( sp-> resulting_height %slices) != 0 )
	      slices --;

	    fprintf(tmpfile,"\
PATTERN IBBPBBPBBPBBPBB\n\
GOP_SIZE 30\n\
SLICES_PER_FRAME 4\n\
PIXEL HALF\n\
RANGE 10\n\
PSEARCH_ALG TWOLEVEL\n\
BSEARCH_ALG CROSS2\n\
IQSCALE 4\n\
PQSCALE 8\n\
BQSCALE 8\n\
REFERENCE_FRAME DECODED\n");
	  }
	  fclose(tmpfile);
	  system(cmd);
	  g_free(cmd);
	  g_free(parmname);
	}
	else
	  show_warning(g_strdup_printf("\
can't open the temporary file %s for writing: %s", tmpname,strerror(errno)));
      }      
    }

    for(ima=0; ima < tot; ima++)
      g_free(name[ima]);
  }
}

