/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.expr.DummyStaticContext;
import com.icl.saxon.handlers.NodeHandler;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.pattern.UnionPattern;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.SAXException;

public class RuleManager {
    private Mode defaultMode;
    private Hashtable modes;

    public RuleManager() {
        this.resetHandlers();
    }

    public void resetHandlers() {
        this.defaultMode = new Mode();
        this.modes = new Hashtable();
    }

    public Mode getMode(String string) {
        if (string == null) {
            return this.defaultMode;
        }
        Mode mode = (Mode)this.modes.get(string);
        if (mode == null) {
            mode = new Mode();
            mode.setName(string);
            this.modes.put(string, mode);
        }
        return mode;
    }

    public void setHandler(String string, NodeHandler nodeHandler) throws SAXException {
        Pattern pattern = Pattern.make(string, new DummyStaticContext());
        this.setHandler(pattern, nodeHandler, this.defaultMode, 0);
    }

    public void setHandler(Pattern pattern, NodeHandler nodeHandler, Mode mode, int n) throws SAXException {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, nodeHandler, mode, n);
            this.setHandler(pattern3, nodeHandler, mode, n);
            return;
        }
        double d = pattern.getDefaultPriority();
        this.setHandler(pattern, nodeHandler, mode, n, d);
    }

    public void setHandler(Pattern pattern, NodeHandler nodeHandler, Mode mode, int n, double d) throws SAXException {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, nodeHandler, mode, n, d);
            this.setHandler(pattern3, nodeHandler, mode, n, d);
            return;
        }
        mode.addRule(pattern, nodeHandler, n, d);
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Context context) throws SAXException {
        return this.getHandler(nodeInfo, this.defaultMode, context);
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Mode mode, Context context) throws SAXException {
        NodeHandler nodeHandler;
        if (mode == null) {
            mode = this.defaultMode;
        }
        if ((nodeHandler = (NodeHandler)mode.getRule(nodeInfo, context)) != null) {
            return nodeHandler;
        }
        return null;
    }

    public NodeHandler getHandler(NodeInfo nodeInfo, Mode mode, int n, int n2, Context context) throws SAXException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return (NodeHandler)mode.getRule(nodeInfo, n, n2, context);
    }

    public Enumeration getAllModes() {
        return this.modes.keys();
    }
}

