/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef Thread_H
#define	Thread_H

#include <wx/thread.h>

class CThread : public wxThread {

    public:
	CThread(const wxString& name);
	virtual ~CThread();

	virtual void start();
	virtual void stop();
	virtual void kill();

	virtual bool isStopped() const;
	virtual bool isRunning() const;

	virtual void* Entry();
	virtual void  reset(bool firstTime);
	virtual void  run() = 0;

	virtual void  error(const wxString& message) = 0;

	virtual wxString getName() const;

    private:
	wxString     m_name;
	bool         m_stopped;
	bool         m_killed;
	wxMutex      m_mutex;
	wxCondition* m_condition;
};

#endif
