#ifndef WE_UI_H
#define WE_UI_H

#include <Ark/Ark.h>
#include <Ark/ArkMath.h>
#include <Ark/ArkMaterial.h>

#include "HeightOps.h"
#include "EntityOps.h"
#include <string>

namespace Ark {class Model; class ClassDef;}
class Entity;


class UI
{
   public:
      UI();
      virtual ~UI();

      virtual void InitEntityOps(const EntityOpList &ops) = 0;
      virtual void InitHeightOps(const HeightOpList &ops) = 0;

      virtual void AddGroundToList (Ark::Material *mat) = 0;
      virtual void AddGroundsToList (const Ark::MaterialList &matlist) = 0;
      
      virtual void UpdateBrowseInfo (Ark::Vector3 pov, Ark::Vector3 la) = 0;
      
      // Enable/disable "Save" menu entry.
      virtual void EnableSaveCommands (bool en) = 0;

      // Enable/disable Undo/Redo commands.
      virtual void EnableUndoCommands (bool en, const std::string &s) = 0;
      virtual void EnableRedoCommands (bool en, const std::string &s) = 0;

      // Entity edition.
      virtual std::string SelectModel(const std::string &prev) = 0;
      virtual Ark::ClassDef *SelectClass() = 0;
      virtual std::string SelectTemplate(Ark::ClassDef *cd) = 0;

      virtual bool EditEntity (Entity *ent) = 0;

      // Create the main window, and loop..
      virtual void MainLoop (int argc, char **argv) = 0;
};


#endif
