// $Id: HFEAbsolute.h,v 1.4 2001/10/28 23:24:43 nekeme Exp $
#ifndef WE_HFE_ABSOLUTE_H
#define WE_HFE_ABSOLUTE_H


#include "HFEditHeight.h"


class HFEAbsolute : public HFEditHeight
{
  public:
    HFEAbsolute(World* w, int type, int size, float att, float str) 
      : HFEditHeight(w, type, size, att, str)
      {
      }

    /// Create a command with a correct state.
    virtual Command* CreateCommand();

  protected:
    int GetOriginal(int x, int z);

};


// ========================================================================
// ========================================================================
// ========================================================================

class HFEBulldozer : public HFEAbsolute
{
  private:
    short m_Height;
    float m_ScalarHeight;


  public:
    HFEBulldozer(World* w, int type, int size, float att, float str) 
      : HFEAbsolute(w, type, size, att, str)
      {
      }

    virtual void Apply(int x,int z);

    virtual HFEditHeight* CreateNew(World* w, int t,int s, float a, float h) const;

  protected:
    virtual void ApplyAtPoint(int x, int z, float factor);
};

// ========================================================================
// ========================================================================
// ========================================================================

class HFESmooth : public HFEAbsolute
{
  public:
    HFESmooth(World* w, int type, int size, float att, float str) 
      : HFEAbsolute(w, type, size, att, str)
      {
      }

    virtual HFEditHeight* CreateNew(World* w,
				    int t,int s, float a, float h) const;

  protected:
    virtual void ApplyAtPoint(int x, int z, float factor);
};

// ========================================================================
// ========================================================================
// ========================================================================
#endif // WE_HF_EDITHEIGHT_H
