// $Id: HFEAbsolute.cpp,v 1.6 2003/02/27 23:43:40 zongo Exp $

#include <stdlib.h>
#include <math.h>

#include "HFEAbsolute.h"
#include "HeightFieldCommand.h"


// ========================================================================
// ========================================================================
// ========================================================================

/// Create a command with a correct state.
Command* 
HFEAbsolute::CreateCommand()
{
    if (!m_State) return 0;

    const unsigned int size = m_World->m_SizeX * m_World->m_SizeZ;
    HeightFieldCommand* command = new HFEHCommand(m_World, "Absolute change");

    for (unsigned int i=0 ; i<size ; ++i)
    {
	const short state = m_State[i];
	if (0 <= state)
	{
	    command->AddState(i, state);
	}
    }

    return command;
}


int
HFEAbsolute::GetOriginal(int x, int z)
{
    short& state = GetState(x, z);

    // This point is modified
    if (state < 0)
    {
	const short world = m_World->Y(x,z);
	state = world;
    }

    return state;
}


// ========================================================================
// ========================================================================
// ========================================================================

void 
HFEBulldozer::Apply(int gx, int gz) 
{
    if (!m_State)
    {
	// initialize with -1 (not touched value)
	InitState( -1 );

	// initialize height to bulldoze
	m_Height = m_World->Y(gx, gz);
	m_ScalarHeight = static_cast<float>( m_Height );
    }
    
    HFEditHeight::Apply(gx, gz);
}


void 
HFEBulldozer::ApplyAtPoint(int x, int z, float factor)
{
    const float att = ComputeStandardAttenuation(factor);

    short world = m_World->Y(x,z);
    const short diff = abs( world - m_Height );

    short& state = GetState(x, z);

    // This point is modified
    if (state < 0)
    {
	state = world;
    }
    // Use original point
    else
    {
	world = state;
    }

    const float sworld = static_cast<float>( world );

    const float midvalue = att * m_ScalarHeight + (1.0f - att) * sworld;
    const short finalHeight = Clamp255( static_cast<int>( midvalue ) );

    // was it worth it ?
    if ( abs( finalHeight - m_Height ) < diff )
    {
	m_World->Y(x, z) = (unsigned char)finalHeight;
    }
}


HFEditHeight* 
HFEBulldozer::CreateNew(World* w, int t, int s, float a, float h) const
{
  return new HFEBulldozer(w, t, s, a, h);
}

// ========================================================================
// ========================================================================
// ========================================================================


void 
HFESmooth::ApplyAtPoint(int x, int z, float factor)
{
    // initialize with -1 (this is done only once)
    InitState( -1 );

    const float att = m_Strength; 
    const float centerw = 4.0f;
    const float weight = 4.0f * att + centerw; 

    const int xn = ClampX( x - 1 );
    const int xp = ClampX( x + 1 );
    const int zn = ClampZ( z - 1 );
    const int zp = ClampZ( z + 1 );

    const float center = centerw * static_cast<float>( GetOriginal(x, z) );

    const int north = GetOriginal(x, zn);
    const int south = GetOriginal(x, zp);
    const int west = GetOriginal(xn, z);
    const int east = GetOriginal(xp, z);

    const int outside = north + south + west + east;
    const float smooth = att * static_cast<float>( outside );

    const float result = ( center + smooth ) / weight;
    
    m_World->Y(x,z) = Clamp255( static_cast<int>( result ) );
}


HFEditHeight* 
HFESmooth::CreateNew(World* w, int t, int s, float a, float h) const
{
  return new HFESmooth(w, t, s, a, h);
}

// ========================================================================
// ========================================================================
// ========================================================================

