#ifndef WE_APPLICATION_H
#define WE_APPLICATION_H

#include <string>

#include <Ark/ArkDataClass.h>

#include "TerrainView.h"
#include "ViewWidget.h"

#include "ToolHelper.h"
#include "WorldHelper.h"
#include "UI.h"

namespace Ark {class CDSystem;}


class Application : public ToolHelper, public WorldHelper
{
   private:
      UI *m_UI;
      TerrainView* m_View;

      Ark::ClassList *m_Classes;
      
   public:
      Application(UI *ui);
      ~Application();

      // Application Singleton
      static Application* GetApplication();

      // Access wrappers.
      inline Ark::Renderer *GetRenderer() const {return m_View->GetRenderer();}
      TerrainView          *GetTerrain() const  {return m_View;}

      inline UI  *GetUI () const {return m_UI;}
      inline void SetUI (UI *ui) {m_UI = ui;}

      // View operations
      void SetView(ViewWidget* view);

      Ark::ClassList *GetClasses() {return m_Classes;}

   public:
      World *GetWorld() {return WorldHelper::GetWorld();}
};

extern Application *g_Application;

#endif
