// TimeSource.hh --- the time
//
// Copyright (C) 2001, 2002, 2003 Rob Caelers <robc@krandor.org>
// All rights reserved.
//
// Time-stamp: <2003-01-05 16:03:42 robc>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// $Id: TimeSource.hh,v 1.1 2004/01/28 12:16:43 dotsphinx Exp $
//

#ifndef TIMESOURCE_HH
#define TIMESOURCE_HH

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

//! A source of time.
class TimeSource
{
public:
  //! Return the time of this source.
  virtual time_t get_time() const = 0;
};

#endif // TIMESOURCE_HH
