/* showimagemode.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: showimagemode.h,v 1.4 2001/11/03 17:10:45 ralf Exp $ */

#ifndef SHOWIMAGEMODE_H
#define SHOWIMAGEMODE_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/message.h>
#include <aguix/listview.h>
#include <aguix/listviewdnd.h>
#include <aguix/stringgadget.h>
#include <aguix/button.h>
#include <aguix/request.h>
#include <aguix/awindow.h>
#include "listermode.h"
#include "datei.h"
#include "normalmode.h"

class Lister;

class ShowImageMode:public ListerMode
{
public:
  ShowImageMode(Lister *);
  virtual ~ShowImageMode();
  virtual void messageHandler(AGMessage *);
  virtual void on();
  virtual void off();
  virtual void activate();
  virtual void deactivate();
  virtual bool isType(const char *);
  virtual const char *getType();
  virtual int configure();
  virtual void cyclicfunc(cyclicfunc_mode_t mode);
  virtual const char* getName();
  virtual int load(Datei*);
  virtual bool save(Datei *);
  virtual void reconfig();
  
protected:
  void reconf(int,int,int,int);
  AWindow *imgwin;
  static const char *type;
  int x,y,w,h;
  void setName();
  
  FileEntry *lastactivefe;
  
  void update(bool force);
  bool checksp(const char *);
  void blank();
  bool blanked;
  
  char *show_program;
};

#endif

