/* $Id: tblock.h,v 1.2 1997/03/21 20:20:53 dps Exp $ */
/* Dynamically grown text block */

#include <string.h>

#ifndef __tblock_h__
#define __tblock_h__

class tblock
{
private:
    struct block
    {
	int limit;
	int pos;
	char *text;
	struct block *next;
    };

    struct block dummy_block;
    struct block *head;

    static const struct block dummy_init;
    static const int block_size=1024;

    const char *collect(void) const;

public:
    inline tblock(void)
    {
	dummy_block=dummy_init;
	head=&dummy_block;
    }
    tblock(const tblock &);
    
    ~tblock(void);
    void zero(void);
    int add(char);
    int add(const char *, int);
    inline int add(const char *s)
    {
	return this->add(s, strlen(s));
    }
    tblock &operator=(const tblock &);
    operator const char *();
};

#endif
