#include "defines.h"

#ifdef HAVE_POP3

#include "pop3client.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>


struct pop3_struct{
    struct sockaddr_in server;
    struct hostent *hp;
    int s;
    int numunread;
    int numtotal;
};


#define BUFLEN 1024


Pop3 initPop3(void) {

    Pop3 pc;

    pc = (Pop3)malloc(sizeof(*pc));
    if (pc == 0) return 0;

    pc->numtotal = 0;
    pc->numunread = 0;

    return pc;
}

int pop3Connect(Pop3 pc, char *serverName, int port) {
    if ((pc->s = socket(AF_INET,SOCK_STREAM,0)) < 0) return -1;

    memset(&(pc->server),0, sizeof(pc->server));
    pc->server.sin_family = AF_INET;
    if ((pc->hp = gethostbyname(serverName)) <= 0)  return -1;

    memcpy( &(pc->server.sin_addr), pc->hp->h_addr, pc->hp->h_length);
    pc->server.sin_port = htons(port);
    if (connect(pc->s, (struct sockaddr *)&(pc->server), sizeof(pc->server)) < 0)
        return -1;
    return 0;
}

int pop3Login(Pop3 pc, char *user, char *pass) {
    
    int size;
    char in[BUFLEN];
    char temp[BUFLEN];
    char out[BUFLEN];

    if ((size = recv(pc->s, in, BUFLEN, 0)) < 1) return -1;

    bzero(temp, BUFLEN);
    memcpy(temp, in, size > BUFLEN ? BUFLEN : size);
    if (temp[0] != '+' ) return -1;

    snprintf(out, BUFLEN, "USER %s\r\n", user);
    send(pc->s, out, strlen(out), 0);
    if ((size = recv(pc->s, in, BUFLEN, 0)) < 1) return -1;

    bzero(temp, BUFLEN);
    memcpy(temp, in, size > BUFLEN ? BUFLEN : size);
    if (temp[0] != '+') return -1;

    snprintf(out, BUFLEN, "PASS %s\r\n", pass);
    send(pc->s, out, strlen(out),0);
    if ((size = recv(pc->s, in, BUFLEN, 0)) < 1) return -1;
    bzero(temp,BUFLEN);
    memcpy(temp, in, size > BUFLEN ? BUFLEN : size);
    if (temp[0] != '+') return -1;
    /*free(in);
    free(temp);
    */
    return 0;
}

int pop3CheckMail(Pop3 pc) {
    
    int size;
    char in[BUFLEN];
    char temp[BUFLEN];
    char out[BUFLEN];
    char *ptr;

    snprintf(out, BUFLEN, "STAT\r\n");
    send(pc->s, out, strlen(out), 0);
    if ((size = recv(pc->s, in, BUFLEN, 0)) < 1) return -1;

    ptr = strtok(in, " ");
    ptr = strtok(0, " ");
    bzero(temp, BUFLEN);
    memcpy(temp, in, size > BUFLEN ? BUFLEN : size);
    if (temp[0] != '+') return -1;

    pc->numtotal = atoi(ptr);
    snprintf(out, BUFLEN, "LAST\r\n");
    send(pc->s, out, strlen(out), 0);
    if ((size = recv(pc->s, in, BUFLEN, 0)) < 1) return -1;

    bzero(temp, BUFLEN);
    memcpy(temp, in, size > BUFLEN ? BUFLEN : size);
    if( temp[0] != '+') {
        pc->numunread = pc->numtotal;
    } else {
        ptr = strtok(in, " ");
        ptr = strtok(0, " ");
        pc->numunread = pc->numtotal - atoi(ptr);
    }
    return 1;
}

int pop3GetTotalMess(Pop3 pc) {
    if (pc != 0) return pc->numtotal;
    return -1;
}

int pop3GetUnreadMess(Pop3 pc) {
    if (pc != 0) return pc->numunread;
    return -1;
}

int pop3Quit(Pop3 pc) {

    int size;
    char in[BUFLEN];

    send(pc->s, "quit\r\n", 6, 0);
    size = recv(pc->s, in, BUFLEN, 0);
    if (pc->s != 0) close(pc->s);
    return 0;
}

void free_pop3(Pop3 *pc) {
    free(*pc);
    *pc = NULL;
}
#endif /* HAVE_POP3 */

