/*
 *  rimage.h
 *
 *  Copyright (C) 1998 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/10/16 18:24:42 $
 *  $Author: hafner $
 *  $Revision: 1.5 $
 *  $State: Exp $
 */

#ifndef _RIMAGE_H
#define _RIMAGE_H

#include "config.h"

#ifdef  PREVIEWS
#ifndef CONVERT

typedef enum gtype {HGRADIENT, VGRADIENT, DGRADIENT} gtype_e;

#include <gtk/gtk.h>
#include <wraster.h>
#include "proplist_t.h"

gboolean
make_color(const gchar *spec, GdkColor *color);
GtkWidget *
make_image (const char *filename, int width, int height, GtkWidget *preview);
GtkWidget *
make_gradient (proplist_t array, unsigned width, unsigned height,
	       gtype_e type, GtkWidget *preview);
#ifdef HAVE_INTERWOVEN_GRADIENT
GtkWidget *
make_igradient (proplist_t array, unsigned width, unsigned height,
		GtkWidget *preview);
#endif /* HAVE_INTERWOVEN_GRADIENT */
GtkWidget *
make_solid (const char *color, unsigned width, unsigned height,
	    GtkWidget *preview);
GtkWidget *
make_textured_gradient (const char *filename, proplist_t array,
			unsigned width, unsigned height,
			gtype_e type, GtkWidget *preview);
void
init_wraster_lib (void);
#ifdef HAVE_LIBWMFUN
GtkWidget *
make_wmfun (proplist_t array, unsigned width, unsigned height,
	    GtkWidget *preview);
#endif /* HAVE_LIBWMFUN */

#endif /* not CONVERT */
#endif /* PREVIEWS */

#endif /* not _RIMAGE_H */
