#!/usr/local/bin/perl
# list_hosts.cgi
# Display host access records

require './postgresql-lib.pl';
$access{'users'} || &error($text{'host_ecannot'});
&header($text{'host_title'}, "", "list_hosts");
print "<hr>\n";

@hosts = &get_hba_config();
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'host_address'}</b></td> ",
      "<td><b>$text{'host_db'}</b></td> ",
      "<td><b>$text{'host_auth'}</b></td> </tr>\n";
foreach $h (@hosts) {
	print "<tr $cb>\n";
	print "<td><a href='edit_host.cgi?idx=$h->{'index'}'>",
	   &html_escape(
	      $h->{'type'} eq 'local' ? $text{'host_local'} :
	      $h->{'netmask'} eq '255.255.255.255' ? $h->{'address'} :
	      $h->{'netmask'} eq '255.255.255.255' ? $text{'host_any'} :
	      $h->{'address'}.'/'.$h->{'netmask'}),"</a></td>\n";
	print "<td>",$h->{'db'} eq 'all' ? $text{'host_all'} :
		     $h->{'db'} eq 'sameuser' ? $text{'host_same'} :
					        $h->{'db'},"</td>\n";
	print "<td>",$text{"host_$h->{'auth'}"},"</td>\n";
	print "</tr>\n";
	}
print "</table>\n";
print "<a href='edit_host.cgi?new=1'>$text{'host_add'}</a><p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

