// ResizePanel
// A panel with left and right parts, whose midpoint is adjustable
import java.awt.*;
import java.util.Vector;

public class ResizePanel extends Panel implements LayoutManager
{
	Component left, right;
	int pos = -1;
	double ratio;
	boolean dragging;
	int border = 100;

	public ResizePanel(Component l, Component r, double rt)
	{
	left = l;
	right = r;
	ratio = rt;
	setLayout(this);
	add(left);
	add(right);
	}

	public void paint(Graphics g)
	{
	Dimension s = size();
	pos = (int)(s.width * ratio);
	g.setColor(Color.white);
	g.drawLine(pos-2, 0, pos+1, 0);
	g.drawLine(pos-2, 0, pos-2, s.height-2);
	g.setColor(Color.black);
	g.drawLine(pos+2, s.height-1, pos-1, s.height-1);
	g.drawLine(pos+2, s.height-1, pos+2, 1);
	}

	public boolean mouseDown(Event evt, int x, int y)
	{
	Dimension s = size();
	int sh = s.height - 50;
	if (x >= pos-2 && x <= pos+2) {
		// Started dragging
		dragging = true;
		}
	return dragging;
	}

	public boolean mouseDrag(Event evt, int x, int y)
	{
	if (dragging) {
		Dimension s = size();
		if (x < border) pos = border;
		else if (x > s.width-border) pos = s.width - border;
		else pos = x;
		ratio = (double)pos / (double)s.width;
		layoutContainer(this);
		repaint();
		}
	return dragging;
	}

	public boolean mouseUp(Event evt, int x, int y)
	{
	boolean o = dragging;
	dragging = false;
	return o;
	}

	public void addLayoutComponent(String name, Component comp)
	{
	}

	public void layoutContainer(Container parent)
	{
	Dimension s = parent.size();
	pos = (int)(s.width * ratio);
	left.reshape(0, 0, pos-3, s.height);
	left.layout();
	right.reshape(pos+3, 0, s.width-pos-5, s.height);
	right.layout();
	}

	public Dimension minimumLayoutSize(Container parent)
	{
	Dimension l = left.minimumSize(),
		  r = right.minimumSize();
	return new Dimension(l.width + r.width,
			     l.height > r.height ? l.height : r.height);
	}

	public Dimension preferredLayoutSize(Container parent)
	{
	return minimumLayoutSize(parent);
	}

	public void removeLayoutComponent(Component comp)
	{
	}
}

