#!/usr/local/bin/perl
# stop_bind.cgi
# Stop bind 8

require './virtual-server-lib.pl';
$access{'stop'} || &error($text{'stop_ecannot'});
&require_bind();
&error_setup($text{'bstop_err'});
if ($bconfig{'stop_cmd'}) {
	# Just use a command
	$out = &backquote_logged("( $bconfig{'stop_cmd'} ) 2>&1");
	if ($?) {
		&error("<pre>$out</pre>");
		}
	}
else {
	# Kill the process
	$pid = &get_bind_pid();
	if (!$pid || !&kill_logged('TERM', $pid)) {
		&error($text{'bstop_epid'});
		}
	}
&webmin_log("stop", "dns");
&redirect("");

