#!/usr/local/bin/perl
# start_bind.cgi
# Start bind 8

require './virtual-server-lib.pl';
$access{'stop'} || &error($text{'start_ecannot'});
&require_bind();
if ($bconfig{'named_user'}) {
	$user = "-u $bconfig{'named_user'}";
	if ($config{'named_group'}) {
		$user .= " -g $bconfig{'named_group'}";
		}
	else {
		local @u = getpwnam($bconfig{'named_user'});
		local @g = getgrgid($u[3]);
		$user .= " -g $g[0]";
		}
	}
if ($bconfig{'start_cmd'}) {
	$cmd = $bconfig{'start_cmd'};
	}
elsif (!$bconfig{'chroot'}) {
	$cmd = "$bconfig{'named_path'} -c $bconfig{'named_conf'} $user </dev/null 2>&1";
	}
elsif (`$bconfig{'named_path'} -help 2>&1` =~ /\[-t/) {
	# use named's chroot option
	$cmd = "$bconfig{'named_path'} -c $bconfig{'named_conf'} -t $bconfig{'chroot'} $user </dev/null 2>&1";
	}
else {
	# use the chroot command
	$cmd = "chroot $bconfig{'chroot'} $bconfig{'named_path'} -c $bconfig{'named_conf'} $user </dev/null 2>&1";
	}

$temp = &tempname();
$rv = &system_logged("$cmd </dev/null >$temp 2>&1");
$out = `cat $temp`;
unlink($temp);
if ($rv || $out =~ /chroot.*not available/i) {
	&error(&bind8::text('start_error', "<tt>$out</tt>"));
	}
&webmin_log("start", "dns");
&redirect("");

