#!/usr/local/bin/perl
# Update frame-forwarding settings

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});

# Validate inputs
&error_setup($text{'frame_err'});
$in{'url'} =~ /^(http|https):\/\/\S+$/ || &error($text{'frame_eurl'});
$d->{'proxy_pass'} = $in{'url'};
$d->{'proxy_title'} = $in{'title'};
$in{'meta'} =~ s/\r//g;
$in{'meta'} =~ s/\n/\t/g;
$d->{'proxy_meta'} = $in{'meta'};

# Run the before command
&set_domain_envs(\%oldd, "MODIFY_DOMAIN");
$merr = &making_changes();
&error(&text('rename_emaking', "<tt>$merr</tt>")) if (defined($merr));

&ui_print_unbuffered_header(&domain_in($d), $text{'frame_title'}, "");

# Force frame re-generation
print $text{'frame_gen'},"<br>\n";
&create_framefwd_file($d);
print $text{'setup_done'},"<p>\n";

# Save the domain
print $text{'save_domain'},"<br>\n";
&save_domain($d);
print $text{'setup_done'},"<p>\n";

# Run the after command
&set_domain_envs($d, "MODIFY_DOMAIN");
&made_changes();
&webmin_log("frame", "domain", $d->{'dom'}, $d);

&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});


