#!/usr/local/bin/perl
# install_pack.cgi
# Install a package from some source

require './cluster-software-lib.pl';
&foreign_require("software", "software-lib.pl");
if ($ENV{REQUEST_METHOD} eq "POST") { &ReadParseMime(); }
else { &ReadParse(); $no_upload = 1; }
&error_setup($text{'install_err'});

if ($in{source} == 2) {
	&ui_print_unbuffered_header(undef, $text{'install_title'}, "", "install_pack");
	}
else {
	&ui_print_header(undef, $text{'install_title'}, "", "install_pack");
	}

if ($in{source} == 0) {
	# installing from local file (or maybe directory)
	if (!$in{'local'})
		{ &install_error($text{'install_elocal'}); }
	if (!-r $in{'local'})
		{ &install_error(&text('install_elocal2', $in{'local'})); }
	$source = $in{'local'};
	$pfile = $in{'local'};
	$need_unlink = 0;
	}
elsif ($in{source} == 1) {
	# installing from upload .. store file in temp location
	if ($no_upload) {
		&install_error($text{'install_eupload'});
		}
	$in{'upload_filename'} =~ /([^\/\\]+$)/;
	$pfile = &tempname("$1");
	open(PFILE, "> $pfile");
	print PFILE $in{'upload'};
	close(PFILE);
	$source = $in{'upload_filename'};
	$need_unlink = 1;
	}
elsif ($in{source} == 2) {
	# installing from URL.. store downloaded file in temp location
	$in{'url'} =~ /\/([^\/]+)\/*$/;
	$pfile = &tempname("$1");
	$progress_callback_url = $in{'url'};
	if ($in{'url'} =~ /^(http|https):\/\/([^\/]+)(\/.*)$/) {
		# Make a HTTP request
		$ssl = $1 eq 'https';
		$host = $2; $page = $3; $port = $ssl ? 443 : 80;
		if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
		&http_download($host, $port, $page, $pfile, \$error,
			       \&progress_callback, $ssl);
		}
	elsif ($in{'url'} =~ /^ftp:\/\/([^\/]+)(:21)?(\/.*)$/) {
		$host = $1; $file = $3;
		&ftp_download($host, $file, $pfile, \$error,
			      \&progress_callback);
		}
	else { &install_error(&text('install_eurl', $in{'url'})); }
	&install_error($error) if ($error);
	$source = $in{'url'};
	$need_unlink = 1;
	}

# Check validity
$ps = &foreign_call("software", "package_system");
if (!&foreign_call("software", "is_package", $pfile)) {
	if (-d $pfile) {
		&install_error(&text('install_edir', $ps));
		}
	else {
		# attempt to uncompress
		local $unc = &foreign_call("software", "uncompress_if_needed",
					   $pfile, $need_unlink);
		if ($unc ne $pfile) {
			# uncompressed ok..
			if (!&foreign_call("software", "is_package", $unc)) {
				unlink($unc);
				&install_error(&text('install_ezip', $ps));
				}
			$pfile = $unc;
			}
		else {
			# uncompress failed.. give up
			unlink($pfile) if ($need_unlink);
			&install_error(&text('install_efile', $ps));
			}
		}
	}

# ask for package to install and install options
@rv = &foreign_call("software", "file_packages", $pfile);

print "<form action=do_install.cgi>\n";
print "<input type=hidden name=file value=\"$pfile\">\n";
print "<input type=hidden name=need_unlink value=\"$need_unlink\">\n";
print "<input type=hidden name=source value='$in{'source'}'>\n";
print "<input type=hidden name=ssl value='$ssl'>\n";
print "<input type=hidden name=host value='$host'>\n";
print "<input type=hidden name=page value='$page'>\n";
print "<input type=hidden name=port value='$port'>\n";
print "<input type=hidden name=ftpfile value='$file'>\n";
print "<input type=hidden name=down value='$in{'down'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'install_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";
print "<tr> <td valign=top><b>$text{'install_packs'}</b></td>\n";
print $software::wide_install_options ? "<td colspan=3>\n" : "<td>\n";
foreach (@rv) {
	($p, $d) = split(/\s+/, $_, 2);
	print "$d ($p)<br>\n";
	push(@pn, $p);
	}
print "</td> </tr>\n";
&foreign_call("software", "install_options", $pfile, $p);

# Show input for hosts to install on
@hosts = &list_software_hosts();
@servers = &list_servers();
print "<tr> <td align=right><b>$text{'install_servers'}</b></td>\n";
print "<td><select name=server>\n";
print "<option value=-1>$text{'edit_all'}\n";
print "<option value=-2>$text{'edit_donthave'}\n";
@groups = &servers::list_all_groups(\@servers);
foreach $h (@hosts) {
	local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;
	print "<option value='$s->{'id'}'>",
		$s->{'desc'} ? $s->{'desc'} : $s->{'host'};
	$gothost{$s->{'host'}}++;
	}
foreach $g (@groups) {
	local ($found, $m);
	foreach $m (@{$g->{'members'}}) {
		($found++, last) if ($gothost{$m});
		}
	print "<option value='group_$g->{'name'}'>",
		&text('edit_group', $g->{'name'}),"\n" if ($found);
	}
print "</select></td> </tr>\n";

print "</table></td></tr>\n";
print "</table><p><input type=submit value=\"$text{'install_ok'}\"></form>\n";

&ui_print_footer("", $text{'index_return'});

sub install_error
{
print "<br><b>$whatfailed : $_[0]</b> <p>\n";
&ui_print_footer("", $text{'index_return'});
exit;
}

