#!/usr/local/bin/perl
# save.cgi
# Save an existing cluster cron job, or create a new one

require './cluster-cron-lib.pl';
&error_setup($text{'save_err'});
&ReadParse();

@jobs = &list_cluster_jobs();
if ($in{'new'}) {
	$job = { 'type' => 0,
		 'cluster_id' => time()."-".$$ };
	}
else {
	($oldjob) = grep { $_->{'cluster_id'} eq $in{'id'} } @jobs;
	$job->{'cluster_id'} = $oldjob->{'cluster_id'};
	$job->{'type'} = $oldjob->{'type'};
	$job->{'file'} = $oldjob->{'file'};
	$job->{'line'} = $oldjob->{'line'};
	$job->{'nolog'} = $oldjob->{'nolog'};
	}

# Check and parse inputs
if ($in{"cmd"} !~ /\S/) {
	&error($cron::text{'save_ecmd'});
	}
if (!$in{'user'}) {
	&error($cron::text{'save_euser'});
	}
&cron::parse_times_input($job, \%in);
$in{input} =~ s/\r//g; $in{input} =~ s/%/\\%/g;
$in{cmd} =~ s/%/\\%/g;
$job->{'active'} = $in{'active'};
$job->{'cluster_command'} = $in{'cmd'};
if ($in{input} =~ /\S/) {
	@inlines = split(/\n/ , $in{input});
	$job->{'cluster_input'} .= join('%' , @inlines);
	}
$job->{'command'} = "$cluster_cron_cmd $job->{'cluster_id'}";
$job->{'cluster_user'} = $in{'user'};
$job->{'user'} = 'root';
$job->{'cluster_server'} = join(" ", split(/\0/, $in{'server'}));

# Make sure the wrapper script exists
if (!-r $cluster_cron_cmd) {
	$perl_path = &get_perl_path();
	&lock_file($cluster_cron_cmd);
	open(CMD, ">$cluster_cron_cmd");
	print CMD <<EOF;
#!$perl_path
open(CONF, "$config_directory/miniserv.conf");
while(<CONF>) {
	\$root = \$1 if (/^root=(.*)/);
	}
close(CONF);
\$ENV{'WEBMIN_CONFIG'} = "$ENV{'WEBMIN_CONFIG'}";
\$ENV{'WEBMIN_VAR'} = "$ENV{'WEBMIN_VAR'}";
chdir("\$root/$module_name");
exec("\$root/$module_name/cron.pl", \$ARGV[0]);
EOF
	close(CMD);
	chmod(0755, $cluster_cron_cmd);
	&unlock_file($cluster_cron_cmd);
	}

if (!$in{'new'}) {
	# Editing an existing job
	&modify_cluster_job($job);
	}
else {
	# Creating a new job
	&create_cluster_job($job);
	}

if ($in{'new'}) {
	&webmin_log("create", "cron", $job->{'cluster_user'}, $job);
	}
else {
	&webmin_log("modify", "cron", $job->{'cluster_user'}, $job);
	}
&redirect("");


