#ifndef HEADINGOBJ_H
#define HEADINGOBJ_H

#include "mapobj.h"

class HeadingObj:public MapObj {
public:
    HeadingObj();
    HeadingObj(QCanvas*);
    virtual ~HeadingObj();
    virtual void init();
    virtual void copy(HeadingObj*);
    virtual void move (double x,double y);      // move to absolute Position
    virtual void moveBy (double x,double y);    // move to relative Position
    virtual void positionBBox();
	virtual void calcBBoxSize();
private:
    QCanvasText* newLine(QString);				// generate new textline
public:    
    virtual void setText(QString);
    virtual QString text();
    virtual void setFont(QFont);
    virtual QFont getFont();
    virtual void setColor(QColor);
    virtual QColor getColor();
    virtual void setVisibility(bool);
	virtual int getHeight();
	virtual int getWidth();

protected:
    QString heading;
    uint textwidth;								// width for formatting text
    QPtrList <QCanvasText> textline;			// a part of e.g. the parabel
    QColor color;
    QFont font;
};
#endif
