/*---------------------------------------------------------------------------*\

    FILE....: COMP.H
    TYPE....: C Function Header File
    AUTHOR..: David Rowe
    DATE....: 17/3/98

	Compression class packs and unpacks compressed speech between the DSP
	FIFOs which require one sample per 16 bit word, and the compressed
	format used by the PC which packs samples as tightly as possible.
	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001, 2006 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __COMP__
#define __COMP__

#include "contypes.h"

// The base class is pure virtual, a different derived class is implemented
// for each compression mode.  This class holds no data, we just use it
// as a covenient and extensible way to add compression modes.
//
// The bytes to words functions convert between the number of words the 
// DSP fifos require and the number of bytes required (given the 
// compression mode) to fill the buffer

class Compression {
public:
	virtual ~Compression() {};
	virtual void pack(char *packedbytesout, word *wordsin, USHORT nwordsin) = 0;
	virtual void unpack(word *wordsout, char *packedbytesin, USHORT nbytesin) = 0;
	virtual USHORT bytes2words(USHORT nbytes) = 0;
	virtual USHORT words2bytes(USHORT nwords) = 0;
};

class PCMCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, USHORT nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, USHORT nbytesin);
	USHORT bytes2words(USHORT nbytes) { return nbytes; }
	USHORT words2bytes(USHORT nwords) { return nwords; }
};

class LinearCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, USHORT nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, USHORT nbytesin);
	USHORT bytes2words(USHORT nbytes) { return nbytes*sizeof(char)/sizeof(word); }
	USHORT words2bytes(USHORT nwords) { return nwords*sizeof(word)/sizeof(char); }
};

class ADPCMCompression : public Compression {
public:
	void pack(char *packedbytesout, word *wordsin, USHORT nwordsin); 
	void unpack(word *wordsout, char *packedbytesin, USHORT nbytesin);
	USHORT bytes2words(USHORT nbytes) { return nbytes*sizeof(word)/sizeof(char); }
	USHORT words2bytes(USHORT nwords) { return nwords*sizeof(char)/sizeof(word); }
};

#endif	/* #ifndef __COMP__	*/

