/*---------------------------------------------------------------------------*\

    FILE....: COFF.H
    TYPE....: C++ Function Header File
    AUTHOR..: David Rowe
    DATE....: 19/11/97
    AUTHOR..: Ron Lee
    DATE....: 11/11/06

    Functions that boot DSP and extract symbol addresses using COFF files.


         Voicetronix Voice Processing Board (VPB) Software
         Copyright (C) 1999-2007 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __COFF__
#define __COFF__

#include <stdint.h>
#include "hip.h"


void coff_load_dsp_firmware(Hip *hip, int board, const char *coff_file);
void coff_check_dsp_firmware(Hip *hip, int board, const char *coff_file);
void coff_get_address(const char *coff_file, const char *symbol, uint32_t *addr);
uint32_t coff_construct_image(const char coff_file, uint16_t buf[], uint32_t buf_len);

#endif	/* #ifndef __COFF__	*/

