/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rdr.OutStream;
import rfb.Encoder;
import rfb.Exception;
import rfb.PixelFormat;

public class ConnParams {
    public int majorVersion;
    public int minorVersion;
    public int width;
    public int height;
    public String name;
    public boolean useCopyRect;
    public boolean supportsLocalCursor;
    public boolean supportsDesktopResize;
    private PixelFormat pf_;
    private int nEncodings_;
    private int[] encodings_;
    private int currentEncoding_;

    public boolean readVersion(InStream inStream) {
        byte[] byArray = new byte[12];
        inStream.readBytes(byArray, 0, 12);
        try {
            if (byArray[0] != 82 || byArray[1] != 70 || byArray[2] != 66 || byArray[3] != 32 || byArray[4] < 48 || byArray[4] > 57 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 46 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57 || byArray[10] < 48 || byArray[10] > 57 || byArray[11] != 10) {
                return false;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        this.majorVersion = (byArray[4] - 48) * 100 + (byArray[5] - 48) * 10 + (byArray[6] - 48);
        this.minorVersion = (byArray[8] - 48) * 100 + (byArray[9] - 48) * 10 + (byArray[10] - 48);
        return true;
    }

    public void writeVersion(OutStream outStream) {
        byte[] byArray = new byte[]{82, 70, 66, 32, (byte)(48 + this.majorVersion / 100 % 10), (byte)(48 + this.majorVersion / 10 % 10), (byte)(48 + this.majorVersion % 10), 46, (byte)(48 + this.minorVersion / 100 % 10), (byte)(48 + this.minorVersion / 10 % 10), (byte)(48 + this.minorVersion % 10), 10};
        outStream.writeBytes(byArray, 0, 12);
        outStream.flush();
    }

    public void setVersion(int n, int n2) {
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public boolean isVersion(int n, int n2) {
        return this.majorVersion == n && this.minorVersion == n2;
    }

    public boolean beforeVersion(int n, int n2) {
        return this.majorVersion < n || this.majorVersion == n && this.minorVersion < n2;
    }

    public boolean afterVersion(int n, int n2) {
        return !this.beforeVersion(n, n2 + 1);
    }

    public PixelFormat pf() {
        return this.pf_;
    }

    public void setPF(PixelFormat pixelFormat) {
        this.pf_ = pixelFormat;
        if (pixelFormat.bpp != 8 && pixelFormat.bpp != 16 && pixelFormat.bpp != 32) {
            throw new Exception("setPF: not 8, 16 or 32 bpp?");
        }
    }

    public int currentEncoding() {
        return this.currentEncoding_;
    }

    public int nEncodings() {
        return this.nEncodings_;
    }

    public int[] encodings() {
        return this.encodings_;
    }

    public void setEncodings(int n, int[] nArray) {
        if (n > this.nEncodings_) {
            this.encodings_ = new int[n];
        }
        this.nEncodings_ = n;
        this.useCopyRect = false;
        this.supportsLocalCursor = false;
        this.supportsDesktopResize = false;
        this.currentEncoding_ = 0;
        int n2 = n - 1;
        while (n2 >= 0) {
            this.encodings_[n2] = nArray[n2];
            if (nArray[n2] == 1) {
                this.useCopyRect = true;
            } else if (nArray[n2] == -239) {
                this.supportsLocalCursor = true;
            } else if (nArray[n2] == -223) {
                this.supportsDesktopResize = true;
            } else if (nArray[n2] <= 255 && Encoder.supported(nArray[n2])) {
                this.currentEncoding_ = nArray[n2];
            }
            --n2;
        }
    }
}

