/*
** This file is part of the ViTE project.
**
** This software is governed by the CeCILL-A license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-A license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
** 
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
** 
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
** 
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-A license and that you accept its terms.
**
**
** ViTE developers are (for version 0.* to 1.0):
**
**        - COULOMB Kevin
**        - FAVERGE Mathieu
**        - JAZEIX Johnny
**        - LAGRASSE Olivier
**        - MARCOUEILLE Jule
**        - NOISETTE Pascal
**        - REDONDY Arthur
**        - VUCHENER Clément 
**
*/

#include <string>
#include <vector>
#include <fstream>
/* -- */
#include <QFile>
#include <QFileInfo>
/* -- */
#include "parser/File.hpp"
#include "parser/Line.hpp"
/* -- */
using namespace std;


File::File() : _filename(""), _current_line(0), _filesize(0.) {
}

void File::open(string &filename) {
    _filename = filename;
    
    close();

    _file.open(filename.c_str(), ios::in);

    _file.seekg (0, ios::end);
    _filesize = _file.tellg();
    _file.seekg (0, ios::beg);

    // For windows, clear the eof byte for ept files after reading the first file
    _file.clear();
}

File::~File() {
    close();
}

void File::get_line(Line &line) {
    string content = "";

    _current_line ++;

    getline(_file, content);
    content.append("\n");

    try {
        line = content;
    }
    catch(char *e) {
        return;
    }

    line.set_line_number(_current_line);
}

bool File::is_eof() const {
    return _file.eof();
}

void File::close() {
    if(_file.is_open()) {
        _file.close();
    }
}

bool File::is_opened() {
    return _file.is_open();
}

bool File::is_a_file() {
    return QFileInfo(QString::fromStdString(_filename)).isFile();
}

float File::get_size_loaded() const {
    if(_filesize != 0) {
        return (float)_file.tellg() / (float)_filesize;
    }
    else {
        return 0.;
    }
}
