/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * February 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb.h>
#include <vdkb/vdkb_replace.h>
#include <string.h>

SearchList VDKBReplaceForm::find_history = SearchList();
SearchList VDKBReplaceForm::replace_history = SearchList();
static char buff[256];
//=============================================
DEFINE_SIGNAL_MAP(VDKBReplaceForm,VDKForm)
  ON_SIGNAL(ok,clicked_signal,Ok),
  ON_SIGNAL(cancel,clicked_signal,Cancel),
  ON_SIGNAL(replaceall,clicked_signal,ReplaceAll)
END_SIGNAL_MAP

/*
 */
bool
VDKBReplaceForm::ReplaceAll(VDKObject*)
{
  char* match = find_combo->Text;
  char* replace = replace_combo->Text;
  int pos = 0;
  if(!strlen(match) || ! strlen(replace))
    return true;
  VDKString entry = match;
  if(! VDKBReplaceForm::find_history.find(entry))
    VDKBReplaceForm::find_history.add(entry);
  entry = replace;
  if(! VDKBReplaceForm::replace_history.find(entry))
    VDKBReplaceForm::replace_history.add(entry);
  while(pos >= 0 && pos < (int) text->Length)
    {
      if(prompt->Checked)
	{
	  pos = text->Search(match, pos, true);
	  if(pos >= 0)
	    {
	      int answer;
	      VDKBReplaceDialog *dlg = 
		new VDKBReplaceDialog(this,
				      match,
				      replace,
				      &answer);
	      dlg->Setup();
	      dlg->ShowModal();
	      switch(answer)
		{
		case 0: //answered yes
		  pos = ReplaceText(pos,match,replace);
		  break;
		case 1: // answered no
		  pos += strlen(match);
		  break;
		case 2: // answered cancel
		default:
		  pos = -1;
		  break;
		}
	    }
	}
      else
	{
	  pos = text->Search(match, pos, true);
	  if(pos >= 0)
	    pos = ReplaceText(pos,match,replace);
	}
    }
Close();
return true;
}
/*
 */
bool
VDKBReplaceForm::Ok(VDKObject*)
{
  char* match = find_combo->Text;
  char* replace = replace_combo->Text;
  if(!strlen(match) || ! strlen(replace))
    return true;
  VDKString entry = match;
  if(! VDKBReplaceForm::find_history.find(entry))
    VDKBReplaceForm::find_history.add(entry);
  entry = replace;
  if(! VDKBReplaceForm::replace_history.find(entry))
    VDKBReplaceForm::replace_history.add(entry);
  if(prompt->Checked)
    {
      int p = text->Search(match, 0, true);
      if(p>=0)
	{
	  sprintf(buff,"%s\n\"%s\"\%s \"%s\"?", 
		  _(replace_dialog_prompts[21]),
		  match,
		  _(replace_dialog_prompts[22]),
		  replace);
	  
	  int result = Application()->MessageBox(
				 APPNAME,
				 buff,
				 MB_YESNO|MB_ICONQUESTION,
				 _(user_messages[user_ok]),
				 _(user_messages[user_no])
				 );
	  if(result == IDYES)
	    ReplaceText(p,match,replace);
	}
    }
  else
    {
      int p = text->Search(match, 0, true);
      if(p>=0)
	ReplaceText(p,match,replace);
    }
  
  Close();
  return true;
}

/*
 */
int
VDKBReplaceForm::ReplaceText(int pos, char* match, char* rep)
{
  text->Pointer = pos;
  gtk_editable_delete_text (GTK_EDITABLE(text->WrappedWidget()),
			    pos,pos+strlen(match));
  //text->ForwardDelete(strlen(match));
  text->Pointer = pos; 
  text->TextInsert(rep); 
  return pos+strlen(rep);
}
/*
 */
bool
VDKBReplaceForm::Cancel(VDKObject*)
{
Close();
return true;
}

/*
 */
VDKBReplaceForm::VDKBReplaceForm(VDKForm* owner, VDKBText* text):
    VDKForm(owner),text(text)
{
}
/*
 */
VDKBReplaceForm::~VDKBReplaceForm()
{
}
/*
 */
void 
VDKBReplaceForm::Setup()
{
  Title = _(replace_dialog_prompts[0]);
  VDKRadioButton *button; 
  VDKFrame *mainframe = new VDKFrame(this,
				     _(replace_dialog_prompts[1]),
				     v_box,shadow_out);
  VDKTable *table1 = new VDKTable(this,2,2);
  mainframe->Add(table1);
  VDKLabel *find_history = new VDKLabel(this,_(replace_dialog_prompts[2]));
  find_combo = new VDKCombo(this);
  table1->AddToCell(find_history,0,0);
  table1->AddToCell(find_combo,0,1);
  VDKLabel *rep_history = new VDKLabel(this,_(replace_dialog_prompts[3]));
  replace_combo = new VDKCombo(this);
  table1->AddToCell(rep_history,1,0);
  table1->AddToCell(replace_combo,1,1);
  //
  if(VDKBReplaceForm::find_history.size() > 0)
    find_combo->PopdownStrings = VDKBReplaceForm::find_history;
  if(VDKBReplaceForm::replace_history.size() > 0)
    replace_combo->PopdownStrings = VDKBReplaceForm::replace_history;

  VDKTable *table2 = new VDKTable(this,2,2);
  mainframe->Add(table2);
  //
  VDKFrame* opt_frame = new VDKFrame(this,
				     _(replace_dialog_prompts[4]),
				     v_box,shadow_etched_in);
  table2->AddToCell(opt_frame,0,0);
  opt_frame->Add(casesens = new VDKCheckButton(this,
					       _(replace_dialog_prompts[5])));
  casesens->Checked = true;
  opt_frame->Add(wholeword = new VDKCheckButton(this,
						_(replace_dialog_prompts[6])));
  wholeword->Enabled = false;
  opt_frame->Add(regex = new VDKCheckButton(this,
					    _(replace_dialog_prompts[7])));    
  regex->Enabled = false;  
  opt_frame->Add(prompt = new VDKCheckButton(this,
					    _(replace_dialog_prompts[8])));
  prompt->Checked = true;
  //
  VDKFrame* dir_frame = new VDKFrame(this,_(replace_dialog_prompts[9]),
				     v_box,shadow_etched_in);
  table2->AddToCell(dir_frame,0,1);
  direction = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(direction,_(replace_dialog_prompts[10]));
  button = new VDKRadioButton(direction,_(replace_dialog_prompts[11]));
  button->Enabled = false;
  direction->SetDefault(0);
  dir_frame->Add(direction); 
  //
  VDKFrame* scope_frame = new VDKFrame(this,_(replace_dialog_prompts[12]),
				       v_box,shadow_etched_in);
  table2->AddToCell(scope_frame,1,0);
  scope = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(scope,_(replace_dialog_prompts[13]));
  button = new VDKRadioButton(scope,_(replace_dialog_prompts[14]));
  button->Enabled = false;
  scope->SetDefault(0);
  scope_frame->Add(scope); 
  //
  VDKFrame* org_frame = new VDKFrame(this,_(replace_dialog_prompts[15]),
				     v_box,shadow_etched_in);
  table2->AddToCell(org_frame,1,1);
  origin = new VDKRadioButtonGroup(this);
  button = new VDKRadioButton(origin,_(replace_dialog_prompts[16]));
  button->Enabled = false;
  button = new VDKRadioButton(origin,_(replace_dialog_prompts[17]));
  origin->SetDefault(1);
  org_frame->Add(origin); 
  Add(mainframe);
  //
  VDKFrame *buttonframe = new VDKFrame(this,NULL,h_box,shadow_etched_in);
  buttonframe->Add(ok = new VDKLabelButton(this,
					   _(replace_dialog_prompts[18])));
  buttonframe->Add(replaceall = new VDKLabelButton(this,
						   _(replace_dialog_prompts[19])));
  buttonframe->Add(cancel = new VDKLabelButton(this,
					       _(replace_dialog_prompts[20])));
  Add(buttonframe,l_justify,false,false,false);
}

/*
===========================================================
*/
DEFINE_SIGNAL_MAP(VDKBReplaceDialog,VDKForm)
  ON_SIGNAL(ok,clicked_signal,Ok),
  ON_SIGNAL(cancel,clicked_signal,Cancel),
  ON_SIGNAL(no_button,clicked_signal,No)
END_SIGNAL_MAP
//==========================================

VDKBReplaceDialog::VDKBReplaceDialog(VDKForm* owner, 
				 char *match,
				 char* rep,
				 int *answer):
  VDKForm(owner),answer(answer),match(match),rep(rep)
{
}
/*
 */
VDKBReplaceDialog:: ~VDKBReplaceDialog()
{
}
/*
 */
void 
VDKBReplaceDialog::Setup()
{
Title = APPNAME;
VDKFrame* frame1 = new VDKFrame(this,NULL,v_box,shadow_etched_in);
sprintf(buff,
	"%s\n\"%s\"\n%s \"%s\"",
	_(replace_dialog_prompts[21]),
	match,
	_(replace_dialog_prompts[22]),
	rep);
VDKLabel* label = new VDKLabel(this,buff);
frame1->Add(label);
VDKFrame *frame2 = new VDKFrame(this,NULL,h_box,shadow_etched_in);
ok = new VDKLabelButton(this,_(replace_dialog_prompts[23]));
no_button = new VDKLabelButton(this,_(replace_dialog_prompts[24]));
cancel = new VDKLabelButton(this,_(replace_dialog_prompts[20]));
frame2->Add(ok);
frame2->Add(no_button);
frame2->Add(cancel);
Add(frame1);
Add(frame2,l_justify,false,false,false);
SetSize(-1,100);
}
/*
 */
bool 
VDKBReplaceDialog::Ok(VDKObject*)
{
*answer = 0;
Close();
return true;
}
/*
 */
bool 
VDKBReplaceDialog::No(VDKObject*)
{
*answer = 1;
Close();
return true;
}
/*
 */
bool 
VDKBReplaceDialog::Cancel(VDKObject*)
{
*answer = 2;
Close();
return true;
}

