/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.6
 * August 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif 
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_newprjwiz.h>
#include <vdkb/vdkb_types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <vdkb/vdkb.h>
static char buff[512];
// into vdkb_bugfix.cc
extern char* BugFix01(const char* where);
extern char *app_wiz_xpm[];
extern char *wizard_wiz_xpm[];
extern char *compo_wiz_xpm[];
extern char *gear_xpm[];
extern char* app_wiz_xpm[];
#include "pixmaps/gnome.xpm"

DEFINE_SIGNAL_MAP(VDKBNewPrjWiz,VDKForm)
  ON_SIGNAL(browsebutton,clicked_signal,OnbrowsebuttonClick),
  ON_SIGNAL(prjname,changed_signal,OnprjnameChanged),
  ON_SIGNAL(prjrootdir,changed_signal,OnprjrootdirChanged),
  ON_SIGNAL(okbutton,clicked_signal,OnokbuttonClick),
  ON_SIGNAL(cancelbutton,clicked_signal,OncancelbuttonClick)
  END_SIGNAL_MAP

// Vdkb_pwiz MAIN FORM  CLASS
/*
  main form constructor
*/
VDKBNewPrjWiz::VDKBNewPrjWiz(VDKForm* owner, char* title,
			     VDKBNewProjectInfo* info):
  VDKForm(owner,title),  info(info)
{
  info->isValid = false;
  canClose = true;
}

/*
  main form destructor
*/
VDKBNewPrjWiz::~VDKBNewPrjWiz()
{
}

/*
  main form gui setup
*/
extern VDKBuilder* TheApp;
void
VDKBNewPrjWiz::GUISetup(void)
{

  SetSize(307,235);
  Title = _("VDKBuilder project wizard");
  frame1 = new VDKFrame(this,
			_("New project"),
			v_box,shadow_etched_in);
  frame1->Shadow = shadow_in;
  frame1->Align = l_justify;
  frame1->SetSize(297,230);
  Add(frame1,0,1,1,0);
  vbox2 = new VDKBox(this,v_box);
  frame1->Add(vbox2,l_justify,1,1,0);
  vbox2->BorderWidth(0);
  fixed3 = new VDKFixed(this);
  vbox2->Add(fixed3,0,1,1,0);
  label7 = new VDKLabel(this,_("Projects root dir"));
  label7->SetSize(92,20);
  fixed3->Add(label7,0,3,1,0);
  label8 = new VDKLabel(this,_("Project name (no ext)"));
  label8->SetSize(128,20);
  fixed3->Add(label8,0,24,1,0);
  VDKString home = (char*) TheApp->user_home;
  home += "/";
  prjrootdir = new VDKEntry(this,0,(char*) home);
  prjrootdir->Editable = false;
  fixed3->Add(prjrootdir,96,0,1,0);

  prjname = new VDKEntry(this,0);
  prjname->SetSize(157,22);
  fixed3->Add(prjname,136,25,1,0);

  browsebutton = new VDKLabelButton(this,"...");
  browsebutton->SetSize(30,23);
  fixed3->Add(browsebutton,256,0,1,0);
  separator0 = new VDKSeparator(this,h_separator);
  separator0->SetSize(302,2);
  fixed3->Add(separator0,0,80,0,0);
  okbutton = new VDKLabelButton(this,_("Ok"));
  okbutton->SetSize(64,32);
  fixed3->Add(okbutton,232,139,1,0);
  cancelbutton = new VDKLabelButton(this,_("Cancel"));
  cancelbutton->SetSize(64,32);
  fixed3->Add(cancelbutton,232,179,1,0);
  pixmap0 = new VDKPixmap(this,app_wiz_xpm,
			  _("A plain VDK application"));
  pixmap0->SetSize(35,32);
  fixed3->Add(pixmap0,2,88,1,0);
  pixmap1 = new VDKPixmap(this,wizard_wiz_xpm,
			  _("A non-gui console application"));
  pixmap1->SetSize(32,32);
  fixed3->Add(pixmap1,2,120,1,0);
  pixmap2 = new VDKPixmap(this,gnome_xpm,
			  _("A Gnome compliant application"));
  pixmap2->SetSize(32,32);
#if HAVE_GNOME
  pixmap2->Enabled = true;
#else
  pixmap2->Enabled = false;
#endif
  fixed3->Add(pixmap2,2,154,1,0);

  VDKString complete = (char*) prjrootdir->Text;
  complete += prjname->Text;
  prjpathname = new VDKEntry(this,0,(char*) complete);
  prjpathname->SetSize(296,22);
  prjpathname->Editable = false;
  fixed3->Add(prjpathname,5,48,1,0);

  prjtypegroup = new VDKRadioButtonGroup(this,v_box);
  prjtypegroup->SetSize(184,95);
  fixed3->Add(prjtypegroup,46,94,1,0);
  plainvdk = new VDKRadioButton(this,_("VDK application"));
  prjtypegroup->Add(plainvdk,1,1,1,0);
  console = new VDKRadioButton(this,_("Console application"));
  prjtypegroup->Add(console,1,1,1,0);
  gnome = new VDKRadioButton(this,_("VDK-Gnome application"));
  prjtypegroup->Add(gnome,1,1,1,0);	
#if HAVE_GNOME
  gnome->Enabled = true;
#else
  gnome->Enabled = false;
#endif
}

/*
  main form setup
*/
void
VDKBNewPrjWiz::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here

}


static char filesel[256];

static void
file_selection_ok (GtkWidget *w,
		   GtkFileSelection *fs)
{
  strcpy(filesel,gtk_file_selection_get_filename (fs));
  VDKBNewPrjWiz* wizard = (VDKBNewPrjWiz*)
    gtk_object_get_user_data(GTK_OBJECT(fs));
  wizard->canClose = true;
  gtk_main_quit();
  gtk_widget_destroy (GTK_WIDGET (fs));
}

static void
file_selection_cancel (GtkWidget *w,
		       GtkFileSelection *fs)
{
  *filesel = '\0';
  VDKBNewPrjWiz* wizard = (VDKBNewPrjWiz*)
    gtk_object_get_user_data(GTK_OBJECT(fs));
  wizard->canClose = true;
  gtk_main_quit();	
  gtk_widget_destroy (GTK_WIDGET (fs));
}


bool
VDKBNewPrjWiz::OnbrowsebuttonClick(VDKObject* sender)
{
  GtkWidget *window = NULL;
  window = gtk_file_selection_new (_("Choose project root dir"));
  gtk_object_set_user_data(GTK_OBJECT(window),(gpointer) this);
  // denies parent to close
  canClose = false;
  gtk_signal_connect
    (GTK_OBJECT (GTK_FILE_SELECTION (window)->ok_button),
     "clicked",GTK_SIGNAL_FUNC(file_selection_ok),window);

  gtk_signal_connect
    (GTK_OBJECT (GTK_FILE_SELECTION (window)->cancel_button),
     "clicked",GTK_SIGNAL_FUNC(file_selection_cancel),window);
  gtk_window_set_modal (GTK_WINDOW(window),TRUE);
  gtk_window_set_transient_for(
			       GTK_WINDOW(window),
			       GTK_WINDOW(Window())
			       );
  gtk_window_position(GTK_WINDOW(window),GTK_WIN_POS_CENTER);
  gtk_widget_show (window);
  gtk_main();
  /*
   patch applied by C R Johnson <iamcliff@ix.netcom.com>
   07-03-2000
  */
  if(*filesel)
    {
      VDKString pathname(filesel);
      VDKString projectName((char*) prjname->Text);
      pathname+= "/";
      prjrootdir->Text = (char*) pathname;
      if(projectName.size() > 0)
	{
	  pathname+= projectName;
	  pathname+="/";
	}
      prjpathname->Text = (char*) pathname;
    }
  return true;
  /*
  if(*filesel)
    {
      VDKString fullname;
      prjrootdir->Text = filesel;
      fullname+=filesel;
      fullname+= prjname->Text;
      fullname+="/";
      prjpathname->Text = (char*) fullname;
    }
  return true;
  */

}

// signal response method
/*
bool
VDKBNewPrjWiz::OnprjnameChanged(VDKObject* sender)
{
  VDKString fullname = (char*) prjrootdir->Text;
  fullname += prjname->Text;
  fullname+="/";
  prjpathname->Text = (char*) fullname;
  return true;
}
*/
/*
  patch applied by C R Johnson <iamcliff@ix.netcom.com>
  07-03-2000
*/
bool
VDKBNewPrjWiz::OnprjnameChanged(VDKObject* sender)
{
  VDKString fullname ((char*) prjrootdir->Text);
  VDKString projectName((char*) prjname->Text);
  if(projectName.size() > 0)
    {
      fullname += projectName;
      fullname+="/";
    }
  prjpathname->Text = (char*) fullname;
  return true;
}

// signal response method
/*
bool
VDKBNewPrjWiz::OnprjrootdirChanged(VDKObject* sender)
{
  VDKString fullname = (char*) prjrootdir->Text;
  fullname += prjname->Text;
  fullname+="/";
  prjpathname->Text = (char*) fullname;
  return true;
}
*/
/*
  patch applied by C R Johnson <iamcliff@ix.netcom.com>
  07-03-2000
*/
bool
VDKBNewPrjWiz::OnprjrootdirChanged(VDKObject* sender)
{
  VDKString fullname = (char*) prjrootdir->Text;
  VDKString projectName((char*) prjname->Text);
  if(projectName.size() > 0)
    {
      fullname += projectName;
      fullname+="/";
    }
  prjpathname->Text = (char*) fullname;
  return true;
}

// signal response method
bool
VDKBNewPrjWiz::OnokbuttonClick(VDKObject* sender)
{
  // checks for project root dir
  if(access((char*) prjrootdir->Text,F_OK))
    {
      sprintf(buff,_("%s directory not found\ncreate it ?"),
	      (char*) prjrootdir->Text);
      if(Application()->MessageBox(APPNAME,buff,
				   MB_ICONQUESTION|MB_YESNO) == IDYES)
	{
	  if(mkdir ((char*) prjrootdir->Text, 0755) < 0)
	    {
	      sprintf(buff,_("failed to create %s directory"),
		      (char*) prjrootdir->Text);
	      Application()->MessageBox(APPNAME,buff,
					MB_ICONINFORMATION|MB_OK);
	      info->isValid = false;
	      return true;
	    }
	}
      else
	{
	  info->isValid = false;
	  return true;
	}
    }
  // checks for project dir
  if(access( (char*) prjpathname->Text,F_OK))
    {
      sprintf(buff,_("%s directory not found\ncreate it ?"),
	      (char*) prjpathname->Text);
      if(Application()->MessageBox(APPNAME,buff,
				   MB_ICONQUESTION|MB_YESNO) == IDYES)
	{
	  if(mkdir ((char*) prjpathname->Text, 0755) < 0)
	    {
	      sprintf(buff,_("failed to create %s directory"),
		      (char*) prjpathname->Text);
	      Application()->MessageBox(APPNAME,buff,
					MB_ICONINFORMATION|MB_OK);
	      info->isValid = false;
	      return true;
	    }
	}
      else
	{
	  info->isValid = false;
	  return true;
	}
    }
  // all checks ok
  info->prjname = (char*) prjpathname->Text;
  info->prjname += (char*) prjname->Text;
  info->prjname += ".prj";
  // ugly patch that checks for for double "//"
  char* rep = BugFix01((char*) info->prjname);
  if(rep)
    {
      info->prjname = rep;
      delete rep;
    }
  info->type = prjtypegroup->Selected;
  info->isValid = true;
  Close();
  return true;
}


// signal response method
bool
VDKBNewPrjWiz::OncancelbuttonClick(VDKObject* sender)
{
  info->isValid = false;
  Close();
  return true;
}



