/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#if HAVE_CONFIG_H
#include <config.h>
#endif

#if !HAVE_GNOME
  #if ENABLE_NLS
    #include <libintl.h>
#define _(str) gettext(str)
#define N_(str) str
  #else
    #define _(str) str
    #define N_(str) str 
  #endif
#else
 #include <gnome.h>
#endif

#include <vdkb/vdkb_grep.h>
extern "C"
{
#include <string.h>
}

DEFINE_SIGNAL_MAP(VDKBGrepDlg,VDKForm)
ON_SIGNAL(OkButton,clicked_signal,OnOkButtonClick),
ON_SIGNAL(CancelButton,clicked_signal,OnCancelButtonClick),
ON_SIGNAL(BrowseButton,clicked_signal,OnBrowseButtonClick),
ON_SIGNAL(ClearFilesButton,clicked_signal,OnClearFilesButtonClick)
END_SIGNAL_MAP

/*
form constructor
*/
VDKBGrepDlg::VDKBGrepDlg(VDKForm* owner, char* title,
			 FileStringArray* selections,
			 char* match):
	VDKForm(owner,title),selections(selections),match(match)
{
}

/*
form destructor
*/
VDKBGrepDlg::~VDKBGrepDlg()
{
}

/*
form setup
*/
void
VDKBGrepDlg::Setup(void)
{
// Modified by plm 02/09/2000, for French translation
//  SetSize(295,105);
  SetSize(375,105);
  Title = _("VDKBuilder grep");
  Vframe1 = new VDKFrame(this,"grep -n",v_box,shadow_etched_in);
  Vframe1->Shadow = shadow_in;
  Vframe1->Align = l_justify;
  Add(Vframe1,0,1,1,0);
  Vbox3 = new VDKBox(this,v_box);
  Vframe1->Add(Vbox3,l_justify,1,1,0);
  Vbox3->BorderWidth(0);
  Table1 = new VDKTable(this,3,2,false);
  Table1->RowSpacing = 2;
  Table1->ColSpacing = 2;
  Vbox3->Add(Table1,0,1,1,0);
  Vbox12 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox12,0,0);
  Label3 = new VDKLabel(this,_("Text to grep"));
  Label3->Justify =  (GtkJustification) 2;
  Vbox12->Add(Label3,0,1,1,0);
  Vbox13 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox13,0,1);
  TextMatchEntry = new VDKEntry(this,0);
  Vbox13->Add(TextMatchEntry,0,1,1,0);
  Vbox14 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox14,1,0);
  Label2 = new VDKLabel(this,_("Files to grep"));
  Label2->Justify =  (GtkJustification) 2;
  Vbox14->Add(Label2,0,1,1,0);
  Vbox15 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox15,1,1);
  Hbox18 = new VDKBox(this,h_box);
  Vbox15->Add(Hbox18,0,1,1,0);
  Hbox18->BorderWidth(0);
  FilesMatchEntry = new VDKEntry(this,0,"");
  FilesMatchEntry->Enabled = false;
  Hbox18->Add(FilesMatchEntry,0,1,1,0);
  BrowseButton = new VDKLabelButton(this,_("Browse.."));
  BrowseButton->SetSize(55,25);
  Hbox18->Add(BrowseButton,0,1,1,0);
  Vbox16 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox16,2,0);
  ClearFilesButton = new VDKLabelButton(this,_("Clear files"));
  Vbox16->Add(ClearFilesButton,0,1,1,0);
  Vbox17 = new VDKBox(this,v_box);
  Table1->AddToCell(Vbox17,2,1);
  Hbox20 = new VDKBox(this,h_box);
  Vbox17->Add(Hbox20,0,1,1,0);
  Hbox20->BorderWidth(0);
  OkButton = new VDKLabelButton(this,_("Ok"));
  OkButton->SetSize(50,25);
  Hbox20->Add(OkButton,0,1,0,0);
  CancelButton = new VDKLabelButton(this,_("Cancel"));
  CancelButton->SetSize(50,25);
  Hbox20->Add(CancelButton,0,1,0,0);
}



// signal response method 
bool
VDKBGrepDlg::OnOkButtonClick(VDKObject* sender)
{
  if(strlen(TextMatchEntry->Text) > 0)
    sprintf(match,"%s", (char*) TextMatchEntry->Text);
  else
    *match = '\0';
  Close();
  return true;
}

// signal response method 
bool
VDKBGrepDlg::OnCancelButtonClick(VDKObject* sender)
{
  *match = '\0';
  Close();
  return true;
}

// signal response method 
bool
VDKBGrepDlg::OnBrowseButtonClick(VDKObject* sender)
{
  VDKFileDialog *child = new VDKFileDialog(this,selections,
					   _("Select files to grep"));
  child->Filter = "*.cc";  
  child->ShowModal();
  if(selections->size() > 0)
    {
      int size = 0,t;
      char* local;
      for(t = 0; t < selections->size();t++)
	{
	  size+= strlen((char*) (*selections)[t]);
	  size+=1;
	}
      local = new char[size+1];
      *local = '\0';
      for(t = 0; t < selections->size();t++)
	{
	  strcat(local,(char*) (*selections)[t]);
	  strcat(local," ");
	}
      FilesMatchEntry->Text = local;
      delete[] local;
    }
  return true;
}

// signal response method 
bool
VDKBGrepDlg::OnClearFilesButtonClick(VDKObject* sender)
{
return true;
}
