/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_object
#define _vdkb_object
#include <vdk/vdk.h>
#include <vdkb/vdkb_prop.h>
#include <vdkb/vdkb_signal.h>

// for common events
#define CONNECT_COMMON_EVENTS \
EventConnect("expose_event",&VDKBObject::BaseExposeEvent,true);\
EventConnect("button_press_event",&VDKBObject::ButtonPressed);\
EventConnect("button_release_event",&VDKBObject::ButtonReleased);\
EventConnect("enter_notify_event",&VDKBObject::OnEnter);\
EventConnect("leave_notify_event",&VDKBObject::OnLeave);\
EventConnect("motion_notify_event",&VDKBObject::OnMouseMove);


class VDKBParser;

// vdkbclass class type enum
#define VDKB_GUI_CLASSES_OFFSET 1024
#define VDKBUILDER_CLASSES_OFFSET 2048
enum {
  vdkbclass_object = 0,
  /* specific vdkbuilder gui class */
  vdkbclass_evcontainer = 512,
  /* gui object classes */
  vdkbclass_form = 1024,
  vdkbclass_gnomeform,
  vdkbclass_panedform, // obsolete
  vdkbclass_labelbutton, // obsolete
  vdkbclass_label,
  vdkbclass_pixmap,
  vdkbclass_menuitem,
  vdkbclass_textwidget,
  vdkbclass_entry,
  vdkbclass_pixmapbutton, // obsolete
  vdkbclass_clist,
  vdkbclass_ctree,
  vdkbclass_sep,
  vdkbclass_rbgroup,
  vdkbclass_guicanvas,
  vdkbclass_combo,
  vdkbclass_checkbutton,
  vdkbclass_radiobutton,
  vdkbclass_spinbutton,
  vdkbclass_progressbar,
  vdkbclass_custombutton,
  vdkbclass_sbar,
  vdkbclass_grid,
  vdkbclass_slider,
  vdkbclass_placeholder,
  // gnome
  vdkbclass_gnomeappbar,
  vdkbclass_date_edit,
  vdkbclass_gnomeentry,
  // xdb
  vdkbclass_xentry,
  vdkbclass_xcheckbutton,
  vdkbclass_xclist,
  vdkbclass_xmemo,
  // end of non-containers widgets
  vdkbclass_none,
  /* gui containers classes */
  vdkbcanvas_class = 2048,
  vdkbevbox_class,
  vdkbframe_class,
  vdkbscrolled_class,
  vdkbmenubar_class,
  vdkbmenu_class,
  vdkbpaned_class,
  vdkbguinotebook_class,
  vdkbtoolbar_class,
  vdkbtable_class,
  vdkbhandlebox_class,
  vdkbpacker_class,
  vdkbfixed_class
};

//===========================================================
class VDKBObjectInspector;
class VDKBGuiForm;
class VDKBObject
{
 // plm
 private:
  bool Marked;
 protected:
  VDKBPropertyList proplist;
  VDKBSignalList siglist;
  VDKString name;
  VDKObject* object;
  void WriteBgProp(char* propname, GtkStateType state, FILE* fp);
  static VDKString nihil_property;
 public:
  VDKBObject(char* name);
  VDKBObject(char* name, VDKObject* o);
  virtual ~VDKBObject();
  void SetPropValue(const char* prop, const char* value);
  VDKString& GetProp(char* prop);
  virtual void WriteOnFrm(FILE* fp,VDKBObject* parentobj);
  void WriteCommonOnFrm(FILE* fp, VDKBObject* parentobj);
  void WriteOnFrmEnd(FILE* fp);
  virtual VDKString& Name(char* s = NULL)
    { if(s) name = s; return name; }
  virtual bool AddToParent(VDKObject* obj, GdkEvent* ev);
  virtual int Type() { return vdkbclass_object; }
  virtual int isA() { return object ? object->isA() : -1; }
  virtual char* VDKName() { return "VDKObject"; }
  // place holders for subclasses
  virtual void PopMenu() {}
  virtual void PopObjectBrowser();
  virtual void Mark();
  virtual void ClearMark();
  static int Counter() { return 0; }
  virtual VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  VDKBPropertyList& PropList() { return proplist; }
  VDKBSignalList& SignalList() { return siglist; }
  // accessing to underlying vdk object
  VDKObject* ObjectFromVDK() { return object; }
  operator VDKObject*() { return object; }
  static char* CreateSource(char* buffer,VDKBParser& parser,char* obj_name);
  static void CreateWidget(VDKBObject* gui_object,
			 char* buffer,VDKBParser& parser);
  // virtual signal handlers
  void SetupSignals(VDKObject*);
  bool ButtonPressed(VDKObject* sender, GdkEvent* ev);
  bool ButtonReleased(VDKObject* sender, GdkEvent* ev);
  bool OnEnter(VDKObject* sender, GdkEvent* ev);
  bool OnLeave(VDKObject* sender, GdkEvent* ev);
  bool OnMouseMove(VDKObject* sender, GdkEvent* ev);
  bool HandleFixed(VDKObject* sender, GdkEventButton *event);
  bool BaseExposeEvent(VDKObject* sender, GdkEvent* ev);
};

#endif


