/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * Revision 0.4.1
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef WIDCONTAIN_H
#define WIDCONTAIN_H
#include <vdk/vdkobj.h>
/*! \class VDKObjectContainer
 *  \brief Containers base class
 *
 *  This class provides a container widget, common class for
 *  specialized containers such as VDKBox, VDKTable etc.
 *  User should not construct explicitely this kind of object.
 *  
 */
class VDKObjectContainer: public VDKObject
{
public:
  VDKObjectContainer(VDKForm* owner);
  virtual ~VDKObjectContainer() {}
  /*!
    Sets container border width
    \param w returns border width if is < 0
   */
  int BorderWidth(int w = -1)
    {
      if(w>=0)
	gtk_container_set_border_width (GTK_CONTAINER (widget),w); 
      return GTK_CONTAINER (widget)->border_width;
    }
  /*!
    Add an object.
  */
  virtual void Add(VDKObject* obj, int , int , int , int );
  /*!
    Remove an object from container, object will be destroyed
    \param obj object to be removed
   */
  void RemoveObject(VDKObject* obj) { obj->Destroy(); }
  /*!
    This function will remove an object from a container
    without destroying it.
    \param obj object to be removed
    Tip: should be used to reparent an widget, or it will leak.
    Example:
    \code
    // remove from source container
    // referencing it otherwise will be destroyed by gtk+
    source->RemoveObjectFromContainer(widget);
    // add to target container
    target->Add(widget);
    // set target as parent to redirect signal flow
    widget->Parent(target);	
    // unref widget again (or it will leak)
    gtk_widget_unref(widget->Widget());
    \endcode
   */
  virtual void RemoveObjectFromContainer(VDKObject* obj);
  /*!
    Remove all objects from container destroying them
   */
  void RemoveObjects();
  /*!
    Find an object with Tag==tag, NULL if fails
    \param tag value to be searched
   */
  VDKObject* FindTag(int tag);
  /*!
    Apply user defined functions to each contained object
   */
  void ForEachDo(void (*action)(VDKObject*));
  /* !
    Select those contained objects that satisfy to user defined
    condition.
    \param list an ItemList filled with all object addresses
    that satisfy condition-
    \condition an user defined function invoked with each object
    as param, function must return either true (satisfy) or false
    value.
   */
  void Select(ItemList* list, bool (*condition)(VDKObject*));
  
};
#endif

