/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/boxes.h"
#include "vdk/forms.h"

VDKBox::VDKBox(VDKForm* owner,int mode)
    :VDKObjectContainer(owner)
{
    switch(mode)
	{
	case v_box:
	    widget = gtk_vbox_new(FALSE,0);
	    break;
	case h_box:
	    widget = gtk_hbox_new(FALSE,0);
	    break;
	default:
	    widget = gtk_vbox_new(FALSE,0);
	}
}


VDKBox::~VDKBox()
{
}

void VDKBox::Add(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{

  switch(justify)
    {
    case l_justify:
      gtk_box_pack_start(GTK_BOX(widget), obj->Widget(),expand,fill,padding);
      break;
    case r_justify:
      gtk_box_pack_end(GTK_BOX(widget), obj->Widget(),expand,fill,padding);
      break;
    default:
      gtk_box_pack_start(GTK_BOX(widget), obj->Widget(),expand,fill,padding);
    }
  // calls ancestor (B.Liskov docet...)
  VDKObjectContainer::Add(obj,0,0,0,0);
}



