/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef CYLINDER_H
#define CYLINDER_H

#include <visu_pairs.h>

/**
 * RESOURCES_CYLINDER_RADIUS_MIN:
 *
 * Minimum value for the radius of cylinder pairs.
 */
#define RESOURCES_CYLINDER_RADIUS_MIN 0.01
/**
 * RESOURCES_CYLINDER_RADIUS_MAX:
 *
 * Maximum value for the radius of cylinder pairs.
 */
#define RESOURCES_CYLINDER_RADIUS_MAX 3.

enum
  {
    cylinder_user_color,
    cylinder_element_color,
    cylinder_nb_color
  };

PairsExtension* pointerToPairExtension_cylinder;

/**
 * initPairsCylinder:
 *
 * This method is used by V_Sim on startup, don't use it on your own.
 *
 * Returns: the cylinder pair extension.
 */
PairsExtension* initPairsCylinder();
/**
 * setCylinderGeneralRadius:
 * @val: a float value.
 *
 * This method allows to change the default value of radius for cylinder pairs.
 * When a pair is rendered via a cylinder, it first checks if that pairs has
 * a specific radius value. If not, it uses the default value set by this method.
 * If the default value is indeed changed, the pairs OpenGl list is not
 * recreated automatically and the calling method should call the visuPairBuild() method
 * according to the return value.
 *
 * Returns: 1 if the calling method should call the visuPairBuild() method, 0 if not.
 */
int setCylinderGeneralRadius(float val);
/**
 * getCylinderGeneralRadius:
 *
 * Get the default value for cylinder radius.
 *
 * Returns: the default value for cylinder radius.
 */
float getCylinderGeneralRadius();
/**
 * setCylinderRadius:
 * @data: a #VisuPairData object ;
 * @val: a float value.
 *
 * This method allows to change the radius value of a specific pair.
 * When a pair is rendered via a cylinder, it first checks if that pairs has
 * a specific radius value set by this method. If not, it uses the default value.
 * If the specific value is indeed changed, the pairs OpenGl list is not
 * recreated automatically and the calling method should call the visuPairBuild() method
 * according to the return value.
 *
 * Returns: 1 if the calling method should call the visuPairBuild() method, 0 if not.
 */
int setCylinderRadius(VisuPairData *data, float val);
/**
 * getCylinderRadius:
 * @data: a #VisuPairData object.
 *
 * Get the radius value for the specified pair.
 *
 * Returns: the radius value.
 */
float getCylinderRadius(VisuPairData *data);

/**
 * setCylinderColorType:
 * @val: a integer that identify the color scheme.
 *
 * It set the color scheme for cylinder pairs. It can be 0 or 1.
 *
 * Returns: 1 if the calling method should call visuPairBuild() and then
 *          emit the redrawing signal, 0 if not.
 */
int setCylinderColorType(int val);
/**
 * getCylinderColorType:
 *
 * Get the color scheme.
 *
 * Returns: an integer corresponding to the color scheme (0 or 1).
 */
int getCylinderColorType();

#endif
