/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD, Damien
	CALISTE, Olivier D'Astier, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD and Damien
	CALISTE and Olivier D'Astier, laboratoire L_Sim, (2001-2005)

	E-mail addresses :
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.
	D'ASTIER, dastier AT iie P cnam P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef SURFACES_RESOURCES_H
#define SURFACES_RESOURCES_H

#include <glib.h>

#include <coreTools/toolColor.h>

/**
 * SurfaceResource_struct:
 * @surfnom: the name of the surface (in UTF-8) ;
 * @color: a #Color for the surface ;
 * @material: the lighting effects of the surface ;
 * @rendered: boolean for the visibility of the surface ;
 * @sensitiveToMaskingPlanes: boolean for the sensitivity of a surface
 * to the masking effect of planes.
 *
 * This structure defines some drawing properties of a set of #Surfaces.
 */
struct SurfaceResource_struct
{
  /* Name used to label the surface. */
  gchar *surfnom;

  /* Material used to draw a specific surface. */
  Color *color;
  float material[5];

  /* Rendered or not */
  gboolean rendered;

  /* Sensitive to masking properties of planes. */
  gboolean sensitiveToMaskingPlanes;
};
/**
 * SurfaceResource:
 *
 * Short name to adress #SurfaceResource_struct objects.
 */
typedef struct SurfaceResource_struct SurfaceResource;

/**
 * isosurfacesGet_resourceFromName:
 * @surf_name: the name of the surface (can be NULL) ;
 * @new: a location to store a boolean value (can be NULL).
 * 
 * This returns the resource information matching the given @surf_name. If
 * the resource doesn't exist, it is created and @new is set to TRUE. If the given
 * name (@surf_name) is NULL, then a new resource is created, but it is not stored
 * and will not be shared by surfaces.
 *
 * Returns: the resource (created or retrieved).
 */
SurfaceResource* isosurfacesGet_resourceFromName(const gchar *surf_name,
						 gboolean *new);
/**
 * isosurfacesCopy_resource:
 * @res: an allocated #SurfaceResource object to receive values ;
 * @res_old: a #SurfaceResource to read the values from.
 * 
 * This method copies all values from @res_old to @res.
 */
void isosurfacesCopy_resource(SurfaceResource *res, SurfaceResource *res_old);
/**
 * isosurfacesFree_resource:
 * @res: an allocated #SurfaceResource object to be freed.
 * 
 * This method frees the memory used by the given resource.
 */
void isosurfacesFree_resource(SurfaceResource *res);

/**
 * isosurfacesResourcesInit:
 *
 * Internal routine called by isosurfacesInit() at startup. Do not use
 * it.
 */
void isosurfacesResourcesInit();

#endif
