#include "cs.h"
/* compute nonzero pattern of L(k,:) */
static
CS_INT cs_ereach (const cs *A, CS_INT k, const CS_INT *parent, CS_INT *s, CS_INT *w,
    CS_ENTRY *x, CS_INT top)
{
    CS_INT i, p, len, *Ap = A->p, *Ai = A->i ;
    CS_ENTRY *Ax = A->x ;
    for (p = Ap [k] ; p < Ap [k+1] ; p++)	/* get pattern of L(k,:) */
    {
	i = Ai [p] ;		    /* A(i,k) is nonzero */
	if (i > k) continue ;	    /* only use upper triangular part of A */
	x [i] = Ax [p] ;	    /* x(i) = A(i,k) */
	for (len = 0 ; w [i] != k ; i = parent [i]) /* traverse up etree */
	{
	    s [len++] = i ;	    /* L(k,i) is nonzero */
	    w [i] = k ;		    /* mark i as visited */
	}
	while (len > 0) s [--top] = s [--len] ; /* push path onto stack */
    }
    return (top) ;		    /* s [top..n-1] contains pattern of L(k,:)*/
}

/* L = chol (A, [Pinv parent cp]), Pinv is optional */
csn *cs_chol (const cs *A, const css *S)
{
    CS_ENTRY d, lki, *Lx, *x ;
    CS_INT top, i, p, k, n, *Li, *Lp, *cp, *Pinv, *w, *s, *c, *parent ;
    cs *L, *C, *E ;
    csn *N ;
    if (!A || !S || !S->cp || !S->parent) return (NULL) ;   /* check inputs */
    n = A->n ;
    N = cs_calloc (1, sizeof (csn)) ;
    w = cs_malloc (3*n, sizeof (CS_INT)) ; s = w + n, c = w + 2*n ;
    x = cs_malloc (n, sizeof (CS_ENTRY)) ;
    cp = S->cp ; Pinv = S->Pinv ; parent = S->parent ;
    C = Pinv ? cs_symperm (A, Pinv, 1) : ((cs *) A) ;
    E = Pinv ? C : NULL ;
    if (!N || !w || !x || !C) return (cs_ndone (N, E, w, x, 0)) ;
    N->L = L = cs_spalloc (n, n, cp [n], 1, 0) ;
    if (!L) return (cs_ndone (N, E, w, x, 0)) ;
    Lp = L->p ; Li = L->i ; Lx = L->x ;
    for (k = 0 ; k < n ; k++)
    {
	/* --- Nonzero pattern of L(k,:) ------------------------------------ */
	Lp [k] = c [k] = cp [k] ;   /* column k of L starts here */
	x [k] = 0 ;		    /* x (0:k) is now zero */
	w [k] = k ;		    /* mark node k as visited */
	top = cs_ereach (C, k, parent, s, w, x, n) ;   /* find row k of L*/
	d = x [k] ;		    /* d = C(k,k) */
	x [k] = 0 ;		    /* clear workspace for k+1st iteration */
	/* --- Triangular solve --------------------------------------------- */
	for ( ; top < n ; top++)    /* solve L(0:k-1,0:k-1) * x = C(:,k) */
	{
	    i = s [top] ;	    /* s [top..n-1] is pattern of L(k,:) */
	    lki = x [i] / Lx [Lp [i]] ; /* L(k,i) = x (i) / L(i,i) */
	    x [i] = 0 ;		    /* clear workspace for k+1st iteration */
	    for (p = Lp [i] + 1 ; p < c [i] ; p++)
	    {
		x [Li [p]] -= Lx [p] * lki ;
	    }
	    d -= lki * CS_CONJ (lki) ;	    /* d = d - L(k,i)*L(k,i) */
	    p = c [i]++ ;
	    Li [p] = k ;	    /* store L(k,i) in column i */
	    Lx [p] = lki ;
	}
	/* --- Compute L(k,k) ----------------------------------------------- */
	if (CS_REAL (d) <= 0 || CS_IMAG (d) != 0)
	    return (cs_ndone (N, E, w, x, 0)) ; /* not pos def */
	p = c [k]++ ;
	Li [p] = k ;		    /* store L(k,k) = sqrt (d) in column k */
	Lx [p] = sqrt (d) ;
    }
    Lp [n] = cp [n] ;		    /* finalize L */
    return (cs_ndone (N, E, w, x, 1)) ; /* success: free E,w,x; return N */
}
