/* ==================================================== ======== ======= *
 *
 *  uxmldoc.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uxmldoc_hpp_
#define _uxmldoc_hpp_
//pragma ident	"@(#)uxmldoc.hpp	ubit:03.06.03"

#include <ubit/ubox.hpp>
#include <ubit/ustr.hpp>
#include <ubit/ext/udoc.hpp>
#include <ubit/xml/uxmldefs.hpp>

/* ==================================================== ======== ======= */
/** XML Abstract Document.
 *  details:
 *  - This is an abstract class. subclasses (such as UHtmlDoc) implement
 *    a specific DTD.
 *  - UDoc::readDoc() reads and creates a Document from a file.
 *    see the UDoc class.
 */
class UXmlDoc : public UXmlElem, public UDoc {
public:
  enum {
    InvalidFile	   = 1<<1,
    EmptyDocument  = 1<<2,
    XMLError       = 1<<3,
    SAXError       = 1<<4,
    DOMError       = 1<<5,
    InvalidElement = 1<<6,
    InvalidAttribute = 1<<7,
    InvalidValue   = 1<<8,
    OtherError     = 1<<9
  };

  UXmlDoc(const UStr& pathname, UDoc::Callbacks* = null);
  virtual ~UXmlDoc();

  virtual UDoc::Errors readFile(const UStr& pathname) = 0;

  const UStr& getDir()  const {return dirname;}
  const UStr& getName() const {return basename;}

  virtual const UDoc::Objects* getObjects() const {return &objects;}
  virtual const UDoc::Links*   getLinks()   const {return &links;}

  virtual int loadMissingObjects();
  ///< returns the # of objects that are still missing

  const DOMDocument* getDomDocument() const {return dom_document;}
  ///< returns the internal Xerces Document. 

  // implementation - - - - - - - - - - - - - - - - - - - - - - - -

  virtual UCall* makeCall(UStr* ref_path);
  virtual UStr*  makePath(const XMLCh* path);
  virtual void   storeObject(UXmlObjectElem*);
  virtual void   storeLink(UXmlLinkElem*);

  virtual UBrick* createAttr(DOMAttr*, UDoc::Errors&);
  virtual UBrick* createElem(DOMElement*, UDoc::Errors&);
  /**<
    * search name in the attr or elem tables and create corresp object.
    * returns an objet that is an UBrick AND {a UXmlAttr or a UXmlElem}
  */
  
  virtual void createTree(const UStr& pathname, DOMDocument*, UDoc::Errors&);
  /**<
    * creates the Ubit tree according to the DOMDocument.
    * Note: the DOMDocument is deleted when the UXmlDoc is destroyed.
    * (hence, two instances of UXmlDoc should not point to the same
    * DOMDocument)
    */

  static void setXmlError(UDoc::Errors& err, int _stat, 
			  const char* mesg, const XMLCh* arg = null);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

protected:
  static class UXmlParser* parser;
  virtual void initModels() = 0;
  virtual const class UXmlAttrModel* getAttrModels() const = 0;
  virtual const class UXmlElemModel* getElemModels() const = 0;
  ///< ! must be redefined by subclasses for parsing a specific DTD !.

  virtual void processWordText(UGroup*, DOMNode*);

private:
  friend class UXmlParser;
  friend class UXmlElem;
  friend class UXmlAttr;

  DOMDocument*  dom_document;
  UStr          dirname,  basename;
  UDoc::Objects objects;
  UDoc::Links   links;
  UDoc::Callbacks* callbacks;  // externe: ne pas detruire
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

