/* ==================================================== ======== ======= *
 *
 *  uunatwin.cpp  [Native Layer: platform dependent implementation]
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uunatwin.cpp	ubit:03.06.04"
#include <iostream>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <ustr.hpp>
#include <uerror.hpp>
#include <ucursor.hpp>
#include <unatdisp.hpp>
#include <uwin.hpp>
#include <umsproto.hpp>
#include <X11/Xatom.h>
using namespace std;

UNatWin::UNatWin() {
  xwin = None;
}

UNatWin::~UNatWin() {
  xwin = None;
  // NOTE:                                   !!! TEMPORAIRE : A REVOIR !!!
  // on ne detruit pas xwin ici mais dans UWinGraph ou endDoubleBuffering
  // deux raisons:
  // a) xwin est soit une XWindow soit un XPimap
  // b) la destruction des XWindow est recursive ce qui pourrait
  //    aboutir a des destructions multiples de la meme XWindow
  // alors il faudra le detruire explicitement a l'endroit ad hoc
  // (c'est typiquement ce qui est fait dans endDoubleBuffering()
  // pour detruire le Pixmap intermediaire)
  //xwin = None;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UNatWin::where(UNatDisp *natdisp, u_pos &_x, u_pos &_y) {
  if (xwin == None) {_x = -1; _y = -1;}
  else {
    //if (natdisp && natdisp->getXDisplay()) {
    //!NB: XGetGeometry ne marche pas dans le cas des Shells car ceux-ci
    //sont inclus dans une fenetre intermediaire cree par le WM
    Window childw;
    int rootx, rooty;
    XTranslateCoordinates(natdisp->getXDisplay(), xwin, 
			  RootWindowOfScreen(natdisp->getXScreen()), 
			  0, 0, &rootx, &rooty, &childw);
    _x = rootx; _y = rooty;
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// move fait par programme (PAS interactivement par l'utilisateur:
// voir UNatDisp::on_configure() pour ce cas)

void UNatWin::move(UNatDisp *natdisp, u_pos x, u_pos y) {
  //cerr << "natwinmove: xwin " << xwin << "/ x " << x << " y " << y << endl;
  if (xwin != None) XMoveWindow(natdisp->getXDisplay(), xwin, x, y);
}

/* ==================================================== ======== ======= */
// resize fait par programme (PAS interactivement par l'utilisateur: 
// voir UNatDisp::on_configure() pour ce cas)

void UNatWin::resize(UNatDisp *natdisp, u_dim w, u_dim h) {
  if (xwin != None) {
    XResizeWindow(natdisp->getXDisplay(), xwin, w, h);
#ifdef WITH_GL
    natdisp->resizeGLViewport(w, h);
#endif
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UNatWin::show(UNatDisp *natdisp, bool state) {
  if (xwin != None) {
    if (state) {
      natdisp->showNotify(xwin, true);
      XMapRaised(natdisp->getXDisplay(), xwin);
    }
    else {
      natdisp->showNotify(xwin, false);
      XUnmapWindow(natdisp->getXDisplay(), xwin);
    }
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UNatWin::toBack(UNatDisp *natdisp) {
  if (xwin != None) XLowerWindow(natdisp->getXDisplay(), xwin);
}

void UNatWin::toFront(UNatDisp *natdisp) {
  if (xwin != None) XRaiseWindow(natdisp->getXDisplay(), xwin);
}

void UNatWin::setTitle(UNatDisp*nd, const UStr&s) {
  XStoreName(nd->getXDisplay(), xwin, s.chars());
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// !attention: defaultPixmap doit deja avoir ete cree!

void UNatWin::initWinAttributes(UNatDisp *nd, 
				XSetWindowAttributes& wattr, 
				unsigned long &wattr_mask) {
  wattr_mask = 0;

  //mettre colormap appropriee par rapport au Visual sinon plantage!
  if (nd->getXColormap() != None) {
    wattr.colormap = nd->getXColormap();
    wattr_mask |= CWColormap;
  }

  //default Pixmap with same depth as UNatDisp
  //INDISPENSABLE, sinon XCreateWindow plante si depth != rootWindow's depth
  //MEME si border_width = 0 !
  wattr.border_pixmap = nd->getDefaultPixmap();
  wattr_mask |=CWBorderPixmap;

  //transparent background
  wattr.background_pixmap = None;
  wattr_mask |= CWBackPixmap;

  //wattr.background_pixel = WhitePixelOfScreen(nd->getXScreen());
  //wattr_mask |= CWBackPixel;

  //wattr.border_pixel = BlackPixelOfScreen(nd->getXScreen());
  //wattr_mask |= CWBorderPixel;

  // curseur standard
  wattr.cursor = nd->getCursor(UCursor::arrow);
  wattr_mask |= CWCursor;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UNatWin::initEventsAndProperties(UNatDisp* nd, UWin* win) {
  XSelectInput(nd->getXDisplay(), this->xwin, 
	       PointerMotionMask
	       | ExposureMask
	       //NB: GrapicsExpose, NoExpose -> field graphics_expose of GC
	       | EnterWindowMask
	       | LeaveWindowMask
	       | ButtonPressMask
	       | ButtonReleaseMask
	       | KeyPressMask
	       | KeyReleaseMask
	       | FocusChangeMask
	       | KeymapNotify
	       | ColormapChangeMask
	       | PropertyChangeMask
	       //VisibilityChangeMask
	       //NB: ne pas utiliser ResizeRedirectMask: c'est pour le WM
	       //et ca fait deconner les Reise, Expose, etc.
	       // ResizeRedirectMask
	       | StructureNotifyMask
	       //SubstructureNotifyMask
	       //SubstructureRedirectMask
	       );

  // Close/Delete Window Protocol
  XSetWMProtocols(nd->getXDisplay(), this->xwin, 
		  &(nd->atoms.WM_DELETE_WINDOW), 1);

  UMSprotocol::setUbitProtocols(nd, this);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

bool UNatWin::realizeDialog(UNatDisp *nd, UNatWin *nw, UWin *win) {
  if (UNatWin::realizeFrame(nd, nw, win)) {
    // l'iconification du MainFrame entraine l'iconification de ce Dialog
    XSetTransientForHint(nd->getXDisplay(),
	 		 nw->xwin,
			 nd->getXWindow());
    return true;
  }
  else return false;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

bool UNatWin::realizeFrame(UNatDisp *nd, UNatWin *nw, UWin *win) {
  if (!nd || nd->getXWindow() == None) {
    UError::error("UNatWin::realizeFrame", UError::Cant_realize_window);
    return false;
  }
  XSetWindowAttributes wattr;
  unsigned long wattr_mask;

  initWinAttributes(nd, wattr, wattr_mask);
  nw->xwin = XCreateWindow(nd->getXDisplay(),
			   RootWindowOfScreen(nd->getXScreen()),//fenetre mere
			   0,0,	         // x,y position
			   10, 10,       // width , height (0,0 crashes!)
			   0,	         // border_width
			   nd->getDepth(),
			   InputOutput,  // Class
			   nd->getXVisual(),
			   wattr_mask,
			   &wattr);
  if (nw->xwin != None) {
    nw->initEventsAndProperties(nd, win);
    return true;
  }
  else {
    UError::error("internal@UNatWin::realizeDialog", 
		  UError::Cant_create_window);
    return false;
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// !!NB: un et un seul Main Frame (les autres Frames sont crees par la
// fct realizeFrame

bool UNatWin::realizeMainFrame(UNatDisp *nd, UNatWin *nw, UWin *win) {
  if (!nd || nd->xwin == None) {
    UError::error("UNatWin::realizeMainFrame", UError::Cant_realize_window);
    return false;
  }
  nw->xwin = nd->xwin;
  nw->initEventsAndProperties(nd, win);
  return true;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

bool UNatWin::realizeMenu(UNatDisp *nd, UNatWin *nw, UWin *win) {
  if (!nd || nd->getXWindow() == None) {
    UError::error("UNatWin::realizeMenu", UError::Cant_realize_window);
    return false;
  }
  XSetWindowAttributes wattr;
  unsigned long wattr_mask;

  initWinAttributes(nd, wattr, wattr_mask);

  //window pas geree par le WM (no borders...) car c'est un menu
  wattr.override_redirect = True;
  wattr_mask |= CWOverrideRedirect;

  //sauve ce qui est sous le le menu pour economiser les reaffichages
  wattr.save_under = True;
  wattr_mask |= CWSaveUnder;

  nw->xwin = XCreateWindow(nd->getXDisplay(),
			   RootWindowOfScreen(nd->getXScreen()),//fenetre mere
			   0, 0,         // x,y position
			   10, 10,       // width, height (0,0 crashes!)
			   0,	         // border_width
			   nd->getDepth(),
			   InputOutput,  // Class
			   nd->getXVisual(),
			   wattr_mask, &wattr);

  if (nw->xwin != None) {
    nw->initEventsAndProperties(nd, win);
    return true;
  }
  else {
    UError::error("UNatWin::realizeMenu", UError::Cant_create_window);
    return false;
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

bool UNatWin::realizeIncrust(UNatDisp *nd, UNatWin *nw, UWin *win){
  UIncrust *ic = dynamic_cast<UIncrust*>(win);

  if (!ic || !nd || !(nd->getXWindow())) {
    UError::error("UNatWin::realizeIncrust",UError::Cant_realize_window);
    return false;
  }

  if (ic->is_external_win) {
    // incrusts a preexisting external X Window
    nw->xwin = ic->xwin;
    if (nw->xwin == None) {
      UError::error("UNatWin::realizeIncrust",UError::Null_external_window);
      return false;
    }
    else {
      //?? XSelectInput(nd->getXDisplay(),xwin, ExposureMask);
    }
  }
  
  else {  // !is_external_win ==> creates a true X Window 
    XSetWindowAttributes wattr;
    unsigned long wattr_mask;

    initWinAttributes(nd, wattr, wattr_mask);

    // il faut rendre cette window sensible aux ExposeEvent car sa
    // parent window ne les recevra pas
    wattr.event_mask = ExposureMask; 
    wattr_mask |= CWEventMask;

    //!ATT BUG: c'est la Window du Disp qui est prise comme parent !BUG!
    //(cad le main frame). Normalement ca devrait etre la Window
    //qui contient reellement cette window

    ic->xwin = nw->xwin = XCreateWindow(nd->getXDisplay(),
					nd->getXWindow(), // Window du Disp!
				    // offsets of this win from toplevel origin
				    // (set by function GuiCreateWidgets)
					0, 0,
					10, 10, 0,  //avoid size = (0,0)!
					nd->getDepth(),
					(unsigned int)InputOutput, 
					nd->getXVisual(),
					wattr_mask, &wattr); 
    if (nw->xwin == None) {
      UError::error("internal@UNatWin::realizeIncrust", 
		    UError::Cant_create_window);
      return false;
    }
    XMapWindow(nd->getXDisplay(), nw->xwin);
  }

  //ic->add(UOn::viewPaint / ucall(nw, nd, ic->winview, &UNatWin::reshapeCB));
  ic->add(UOn::viewPaint / ucall(nw, nd, (UWin*)ic, &UNatWin::reshapeCB));
  return true;
}

void UNatWin::reshapeCB(UNatDisp* nd, UWin* win) {
  UView* winview = win->getWinView(&nd->getDisp());
  move(nd, winview->getXwin(), winview->getYwin());
  resize(nd, winview->getWidth(), winview->getHeight());
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
