/* ==================================================== ======== ======= *
 *
 *  uumenu.cpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uumenu.cpp	ubit:03.05.05"
#include <iostream>
#include <ubrick.hpp>
#include <uerror.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <ustr.hpp>
#include <ucond.hpp>
#include <uctrl.hpp>
#include <ubox.hpp>
#include <uwin.hpp>
#include <uwinImpl.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <uevent.hpp>
#include <ustyle.hpp>
#include <ucolor.hpp>
#include <uborder.hpp>
#include <ugraph.hpp>
#include <unatwin.hpp>
#include <uappli.hpp>
#include <uflow.hpp>
#include <umenu.hpp>
#include <umenuImpl.hpp>
using namespace std;

const int MAX_CASCADED_MENUS = 25;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UPopmenu::style = null;
const UStyle& UPopmenu::makeStyle() {
  if (!style) style = new UStyle(UMenu::makeStyle());
  return *style;
}

UPopmenu::UPopmenu(const UArgs& a) : UMenu(a) {
  setCmodes(UMode::WIN_AUTO_OPEN_MODE, false);
}

/* ==================================================== ======== ======= */

void UPopmenu::autoOpens(UBox& opener, u_id buttons, u_id keysym,
                         bool active_on_children) {

  InputCond ic(0, buttons, keysym);
  vector<InputCond> ics;
  ics.push_back(ic);
  autoOpens(opener, ics, active_on_children);
}

/* ==================================================== ======== ======= */

void UPopmenu::autoOpens(UBox& opener,
                         const vector<InputCond>& _input_conds,
                         bool active_on_children) {
  input_conds = _input_conds;
  
  if (active_on_children) {
    // ceci permet d'ouvrir le menu meme si opener a des enfants
    // (opener recevra bien l'evenement d'ouverture)
    opener.add(UOn::preChildEvent / ucall(this, &UPopmenu::autoOpenImpl));
  }
  else {
    opener.addAttr(UOn::mpress / ucall(this,&UPopmenu::autoOpenImpl));
    opener.addAttr(UOn::kpress / ucall(this, &UPopmenu::autoOpenImpl));
  }
}

/* ==================================================== ======== ======= */

bool UPopmenu::autoOpenCheck(UEvent& e){
  if (e.getID()!=UEvent::mpress && e.getID()!=UEvent::kpress)
    return false;
  
  for (unsigned int k = 0; k< input_conds.size(); k++) {
    if ((e.getID()==UEvent::mpress
         && input_conds[k].buttons != 0
         && e.getButtons() == input_conds[k].buttons
         && e.getMods() == input_conds[k].mods
         )
        ||
        (e.getID()==UEvent::kpress
         && input_conds[k].keysym != 0
         && e.getKeySym() == input_conds[k].keysym
         && e.getMods() == input_conds[k].mods
         )
        )
      return true;
  }
  return false;
}

/* ==================================================== ======== ======= */

void UPopmenu::autoOpenImpl(UEvent& e) {
  if (autoOpenCheck(e)) {
    move(e, 0,0);
    open();
  }
}

/* ==================================================== ======== ======= */
/*    
  }
  if ((state != 0
       && *
       && (e.getState() == buttons))
      || 
      (keysym != 0
       && e.getID()==UEvent::kpress
       && (e.getKeySym() == keysym))
      ) 
}
 */

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UMenubar::style = null;
const UStyle& UMenubar::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->textSeparator  = &ustr("\t");
    style->orient         = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::FLEX;
    style->local.hspacing = 4;
    style->local.vspacing = 5;
    style->local.padding.set(2, 2); //!!
    style->local.border   = &UBorder::shadowOut;
  }
  return *style;
}

/* ==================================================== ======== ======= */

UMenubar::UMenubar(const UArgs& a): UBar(a) {
  // fermeture automatique quand on clique sur les enfants
  setCmodes(UMode::HAS_CLOSE_MENU_MODE
            | UMode::CLOSE_MENU_MODE
            | UMode::CAN_BROWSE_CHILDREN,
            true);
  
  // recupere evenements dans les enfants
  onPostChildEvent(UOn::enter / ucall(this, &UMenubar::enterChild)
                   + UOn::leave / ucall(this, &UMenubar::leaveChild)
                   + UOn::mrelax / ucall(this, &UMenubar::relaxChild));
}

/* ==================================================== ======== ======= */

// toujours appele APRES enterOpener qd ce dernier est applicable
void UMenubar::enterChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  mc.enterMenubarChild(e, e.getSource() == this);
}

void UMenubar::leaveChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  mc.leaveMenubarChild(e, e.getSource() == this);
}

void UMenubar::relaxChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  if (e.getSource()) mc.relaxMenuChild(e);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UMenu::style = null;
const UStyle& UMenu::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->textSeparator  = &ustr("\n");
    style->orient         = UOrient::VERTICAL;
    style->local.halign   = UHalign::FLEX;
    style->local.valign   = UValign::TOP;
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    style->local.padding.set(6, 3);
    style->local.border   = &UBorder::shadowOut;
    style->font           = &UFont::standard;

    style->fgcolors = UStyle::makeColors(&UColor::navy, &UColor::white); 
    style->bgcolors = UStyle::makeColors(&UBgcolor::white, &UBgcolor::teal);
    style->local.alpha = 0.75;
    /*
    style->fgcolors = UStyle::makeColors(&UColor::white, &UColor::orange); 
    style->bgcolors = UStyle::makeColors(&UBgcolor::black, &UBgcolor::white);
    style->local.alpha = 0.5;
    */
  }
  return *style;
}

/* ==================================================== ======== ======= */

UMenu::UMenu(const UArgs& a) : UWin(a) {

  // CLOSE_MENU_MODE : fermeture automatique quand on clique sur les enfants
  // new 9jn03: MENU and CAN_BROWSE_CHILDREN
  setCmodes(UMode::HAS_CLOSE_MENU_MODE
            | UMode::CLOSE_MENU_MODE
            | UMode::CAN_BROWSE_CHILDREN
            | UMode::MENU,
            true);

  menuBrowsingGroup = null;
  placement = null;
  enter_opener = arm_opener = disarm_opener = null;
  // recupere evenements dans les enfants
  onPostChildEvent(UOn::enter / ucall(this, &UMenu::enterChild)
		   + UOn::leave / ucall(this, &UMenu::leaveChild)
		   + UOn::mrelax / ucall(this, &UMenu::relaxChild)
     );
}

// necessaire a cause de removingFrom (car les fct ne sont pas virtuelles
// dans les desctructeurs!)
UMenu::~UMenu() {
  // att: reset du MenuCtrl si on detruit le menu
  UAppli *a = UAppli::getApp();
  if (a) a->closeRelatedMenus(this);
  if (placement) delete(placement); placement = null;
  destructs();
}

bool UMenu::realize() {
  if (is_hardwin) return realizeHardwin(&UNatWin::realizeMenu);
  else {
    error("internal@UMenu::realize", UError::Cant_realize_softwin);
    return false;
  }
}

/* ==================================================== ======== ======= */

void UMenu::addingTo(ULink *selflink, UGroup *parent) {
  UWin::addingTo(selflink, parent);

  if (isCmode(UMode::WIN_AUTO_OPEN_MODE)) {
    if (!enter_opener) {
      //doit etre arm et pas mpress, car arm change le BrowsingGroup
      // (et disarm egalement)
      // NB:                                   !! prendre en compte arm 3 !!
      enter_opener = &ucall(this, &UMenu::enterOpener);
      arm_opener   = &ucall(this, &UMenu::armOpener);
      disarm_opener= &ucall(this, &UMenu::disarmOpener);
    }
    //!!ATT: risque de pas marcher si le parent est un UGroup !!!
    // mais c'est un bug a corriger ailleurs ...
    
    parent->addAttr(UOn::enter  / enter_opener);
    parent->addAttr(UOn::arm    / arm_opener);
    parent->addAttr(UOn::disarm / disarm_opener);
  }
}

//NB: removingFrom() requires a destructor to be defined
void UMenu::removingFrom(ULink *selflink, UGroup *parent) {
  if (enter_opener) {
    // don't delete the ucalls as they are shared

    parent->removeAttr(enter_opener, false, false);
    parent->removeAttr(arm_opener, false, false);
    parent->removeAttr(disarm_opener, false, false);
  }
  UWin::removingFrom(selflink, parent);
}

/* ==================================================== ======== ======= */

UGroup* UMenu::getBrowsingGroup() {
  return (menuBrowsingGroup ? menuBrowsingGroup : this);
}

void UMenu::setPlacement(const UPlacement *pl) {
  if (placement) delete(placement);
  if (pl) placement = new UPlacement(*pl);
  else placement = null;
}
void UMenu::setPlacement(const UPlacement &pl) {
  setPlacement(&pl);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

// toujours appele AVANT enterChild qunad ce dernier est applicable
void UMenu::enterOpener(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  mc.enterMenuOpener(e, this);
}

// toujours appele APRES enterOpener qd ce dernier est applicable
void UMenu::enterChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  // on n'est pas sur le menu lui-meme
  if (e.getSource() != this) mc.enterMenuChild(e, this);
}


void UMenu::armOpener(UEvent& e) {
  openImpl(e.getFlow()->getMenuCtrl(),
	   e.getView(), // <- opener_view, v menuGroup
	   e.getSourceProps().parentBrowsingGroup, true);
}

void UMenu::disarmOpener(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  // Cette fonction est appelee par les boutons qui ouvrent un submenu.
  // Elle a pour effet de reinitialiser le browsingGroup 
  // et les vars d'etat du menuCtrl
  e.getFlow()->setBrowsingGroup(menuBrowsingGroup);
  mc.active_menu = this;
  mc.active_opener = e.getView(); //verif
}

/* ==================================================== ======== ======= */

void UMenu::leaveChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  // if (e.getSource() != this) test supprime car il faut qu'un 
  // mrelease sur le menu ou un objet non reactif ferme ce menu
  if (e.getSource()) mc.leaveMenuChild(e);
}

// toujours invoque APRES le disarm (si celui-ci a ete appele)
void UMenu::relaxChild(UEvent& e) {
  UMenuCtrl& mc = e.getFlow()->getMenuCtrl();
  // if (e.getSource() != this) test supprime car il faut qu'un 
  // mrelease sur le menu ou un objet non reactif ferme ce menu
  if (e.getSource()) mc.relaxMenuChild(e);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UMenu::close(int status) {
  if (status < 0) status = 0;
  UAppli* a = getAppli();
  // fermer tous les menus, sinon il y a des cas (en part. avec les filebox)
  //  ou certains super menus restent ouverts
  if (a) {
    a->setModalStatus(status);
    a->closeRelatedMenus(this);
  }
  // show(false);necessaire si le menu n'a pas ete ouvert avec open 
  // et n'est donc pas gere par closeSubMenus()
  UBox::close(status);
}

void UMenu::open() {
  UAppli* a = getAppli();
  if (!a) error("open", UError::Unrealized_window);
  else openImpl(a->openFlow(0)->getMenuCtrl(), null, null, false);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UMenu::openImpl(UMenuCtrl& mc, UView* opener, UGroup* menugroup, 
		     bool auto_place) {

  UView* winview = getWinView(opener ? opener->getDisp() : null);
  if (!winview)  {
    error("UMenu::openImpl", UError::Unrealized_window);
    return;
  };

  UMenu* parent_menu = null;
  bool is_cascaded;
  if (mc.isActive()
      // s'il y a deja un MenuGrab et la Win qui contient l'opener 
      // est egalement un menu (de type UMenu ou UPopmenu) alors 
      // le menu que l'on veut maintenant afficher est cascade 
      // ==> ne pas enlever tous les menus deja affiche par closeAllMenus
      //     mais enlever seulement ceux qui ont ete ouverts apres le menu
      //     qui contient l'opener (= 'parent_menu')
      && opener
      // && ((parent_menu = dynamic_cast<UMenu*>(opener->getWinView()->getBox())))
      // !!! FAUX pour softwins !!!!!!                 !!!!!
      && ((parent_menu = dynamic_cast<UMenu*>(opener->getHardwin())))
      ) {
    is_cascaded = true;
    mc.closeSubMenus(parent_menu);
  }
  else {
    is_cascaded = false;
    mc.closeAllMenus(false);
  }

  // cas d'erreur: le menu ne peut etre realize
  if (is_hardwin) {
    if (!this->realize()) return;
  }

  // affecter le browsingGroup de UAppli:
  // -- c'est celui herite du graphe d'instanciation
  //    (en particulier le cas des menubars ou des menus cascades)
  // -- sauf s'il est nul auquel cas le browsingGroup sera l'opener
  //    qui a provoque l'ouverture du menu (cad: opener_view->getBox())
  // -- et si l'opener est nul ce sera le menu lui-meme

  menuBrowsingGroup = menugroup;
  if (!menuBrowsingGroup) menuBrowsingGroup = this; // le menu lui-meme

  //positionner le menu
  if (opener) {
    if (placement) move(opener, *placement);
    else if (auto_place) {	 // default rules
      UPlacement pl;
      if (is_cascaded) {
	pl.halign = &UHalign::right;
	pl.hoppositeBorder = true;
	pl.hdist = 1;
      }  
      else {
	pl.valign = &UValign::bottom;
	pl.voppositeBorder = true;
	pl.vdist = 1;
      }
      move(opener, pl);
    }
  }

  mc.activateMenu(opener, this, menuBrowsingGroup);

  // le grab physique fait en sorte que le menu se ferme automatiquement
  // si on clique la souris (ou si ou tape une touche du clavier)
  // qunad la souris est en dehors de l'application
  // (ie. si le grab physique etait supprime les menus resteraient ouverts
  //  en permanence qunad la souris est dans une autre appli, ce qui n'est
  //  pas completement delirant mais n'est pas conforme a l'usage)

  if (is_hardwin)  winview->wg().grabPointer();  //!!!! que hardwin ?
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UMenuCtrl::~UMenuCtrl() {}

UMenuCtrl::UMenuCtrl(UFlow* _iflow) :
  iflow(*_iflow)
{
  // grabbed menus
  menu_count = 0;
  menu_stack = new UGroup*[MAX_CASCADED_MENUS+1];
  for (int k = 0; k <= MAX_CASCADED_MENUS; k++) menu_stack[k] = null;
  active_menu = null;
  active_opener = null;

  possible_opener = null;
  possible_opener_menu = null;
  possible_closer = null;
  possible_closer_menu = null;
  
  open_timer = iflow.getAppli().openTimer(0, 0);
  open_timer->onAction(ucall(this, &UMenuCtrl::openMenuAfterDelay));

  close_timer = iflow.getAppli().openTimer(0,0);
  close_timer->onAction(ucall(this, &UMenuCtrl::closeMenuAfterDelay));
}

bool UMenuCtrl::isActive() const {
  return (menu_count > 0);
}

bool UMenuCtrl::isActive(UGroup* menu) const {
  for (int k = 0; k < menu_count; k++) 
    if (menu_stack[k] == menu) return true;
  return false;   // not found
}

void UMenuCtrl::closeAllMenus(bool stop_auto_open_mode) {  
  for (int k = 0; k < menu_count; k++) {
    // !!ATT: standard show() mthd, not the specific close() method.
    menu_stack[k]->show(false);
  }
  menu_count = 0;

  if (stop_auto_open_mode) {
    iflow.setBrowsingGroup(null);
    active_menu = null;
    active_opener = null;
  }
}

// ferme tous les grabbed menus sauf 'menu' et ceux qui l'ont ouvert
// (ie qui sont au dessus dans la liste)

void UMenuCtrl::closeSubMenus(UMenu* menu) {
  int k, found = -1;
  for (k = 0; k < menu_count; k++)
    if (menu_stack[k] == menu) {
      found = k;      
      break;
    }

  if (found < 0) {// not found
    closeAllMenus(false);
    return;
  }

  // if !included skip this menu
  k++; found++;

  for ( ; k < menu_count; k++) {
    // !!ATT: standard show() mthd, not the specific close() mthd.
    menu_stack[k]->show(false);
  }
  menu_count = found;
}

void UMenuCtrl::activateMenu(UView *opener, UMenu* menu, 
			     UGroup *menuBrowsingGroup) {
  iflow.setBrowsingGroup(menuBrowsingGroup);
  active_menu = menu;
  active_opener = opener;

  // ajouter ce menu a la liste des grabbedMenus de l'appli
  if (menu_count <= MAX_CASCADED_MENUS) {
    menu_stack[menu_count] = menu;
    menu_count++;
  }

  menu->show(true);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// toujours appele AVANT enterChild qunad ce dernier est applicable

void UMenuCtrl::enterMenuOpener(UEvent& e, UMenu* menu_to_open)
{
  // si autoOpenMode et meme browsing group, alors auto ouvrir
  if (iflow.getBrowsingGroup()
      && e.getSourceProps().parentBrowsingGroup == iflow.getBrowsingGroup()
      ) {
    possible_opener = e.getView();
    possible_opener_menu = menu_to_open;
    possible_closer = null;
    possible_closer_menu = null;
    open_timer->reset(UAppli::getDefaults().auto_open_menu_delay,
                      /*times*/1);
  }
}

/* ==================================================== ======== ======= */

void UMenuCtrl::enterMenubarChild(UEvent& e, bool inside_menubar) {
  
  if (iflow.getBrowsingGroup()
      && e.getSourceProps().parentBrowsingGroup == iflow.getBrowsingGroup()){

    leaveMenubarChild(e, inside_menubar);
    
    // set by enterMenuOpener
    if (!inside_menubar && possible_opener && possible_opener_menu) {
      possible_opener_menu->openImpl(*this, possible_opener,
                                     iflow.getBrowsingGroup(),
                                     true/*autoplace*/);
    }
    possible_opener = null;
    possible_opener_menu = null;
  }
}

void UMenuCtrl::leaveMenubarChild(UEvent& e, bool inside_menubar) {
  if (iflow.getBrowsingGroup()
      && e.getSourceProps().parentBrowsingGroup == iflow.getBrowsingGroup()){

    if (active_menu) {
      if (inside_menubar) closeAllMenus(true);
      else closeSubMenus(active_menu);
    }
    possible_closer = null;
    possible_closer_menu = null;
  }
}
  
/* ==================================================== ======== ======= */
// toujours appele APRES enterOpener qunad ce dernier est applicable

void UMenuCtrl::enterMenuChild(UEvent& e, UMenu* containing_menu)
{
  // on est toujours sur le meme bouton (enterMenuChild est apppele
  // apres enterMeuOpener)
  if (possible_opener == e.getView()) {
     possible_closer = null;
  }

  else {
    // on a change de bouton avant l'ouverture du menu
    // => interdire son ouverture
    possible_opener = null;

    // il y a deja un menu ouvert => le fermer (avec delai)
    if (active_menu
	// ni sur l'opener du menu (sinon fermerait le menu qu'il a ouvert)
	&& active_opener != e.getView()
	// on est bien dans le meme menu group (dans les cas ou il y a
	// plusieurs menu groups, interdire les interactions indesirables
	// entre eux (seul un btn d'un meme menu group que le menu ouvert
	// doit pouvoir le fermer
	&& iflow.getBrowsingGroup()
	&& e.getSourceProps().parentBrowsingGroup == iflow.getBrowsingGroup()
	// en plus si c'est un enfant contenu dans le menu ouvert (ou un
	// sous menu) il ne faut bien sur pas le fermer
        && !e.getSource()->isChildOf(active_menu, true)
        ) {
          possible_closer = e.getView();
          possible_closer_menu = containing_menu;
          close_timer->reset(UAppli::getDefaults().auto_open_menu_delay,
                             /*time*/1);
    }
  }
}

void UMenuCtrl::leaveMenuChild(UEvent& e) {
  if (possible_closer == e.getView())
    possible_closer = null;
  if (possible_opener == e.getView())
    possible_opener = null;
}

void UMenuCtrl::relaxMenuChild(UEvent& e) {
  if (active_opener != e.getView() && e.getSourceProps().autoCloseMenu) {
    closeAllMenus(true);
    //active_menu = null;
    //active_opener = null;
  }
}

/* ==================================================== [Elc:03] ======= */

void UMenuCtrl::openMenuAfterDelay() {
  if (possible_opener && possible_opener_menu) {
    possible_opener_menu->openImpl(*this, possible_opener,
                                   iflow.getBrowsingGroup(),
                                   true/*autoplace*/);
    possible_opener = null;
    possible_opener_menu = null;
  }
}

void UMenuCtrl::closeMenuAfterDelay() {
  if (possible_closer && possible_closer_menu) {
    closeSubMenus(possible_closer_menu);
    possible_closer = null;
    possible_closer_menu = null;
  }
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
