/* ==================================================== ======== ======= *
 *
 *  uugadgets.cpp
 *  Ubit Project [Elc::2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uugadgets.cpp	ubit:03.06.04"
#include <iostream>
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <ustr.hpp>
#include <uctrl.hpp>   
#include <ubox.hpp>
#include <uwin.hpp>
#include <umenu.hpp>
#include <ugadgets.hpp>
#include <usymbol.hpp>
#include <ustyle.hpp>
#include <ucolor.hpp>
#include <uborder.hpp>
#include <ucursor.hpp>
#include <unumber.hpp>
#include <uevent.hpp>
#include <uview.hpp>
#include <uappli.hpp>
#include <uflow.hpp>
#include <uedit.hpp>
#include <uchoice.hpp>
#include <uima.hpp>
//#include <upane.hpp>
using namespace std;

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

USepar::USepar(const UArgs& a) : UBox(a) {
  orient = UOrient::HORIZONTAL;
  setCmodes(UMode::HAS_CLOSE_MENU_MODE, true);
  setCmodes(UMode::CLOSE_MENU_MODE, false);
}

USepar::USepar(const UOrient& o, const UArgs& a) : UBox(a) {
  orient = o.get();
  setCmodes(UMode::HAS_CLOSE_MENU_MODE, true);
  setCmodes(UMode::CLOSE_MENU_MODE, false);
}

USepar& usepar(const UArgs& a)
{return *new USepar(a);}

USepar& usepar(const UOrient& o, const UArgs& a)
{return *new USepar(o,a);}

USepar& uhsepar(const UArgs& a)
{return *new USepar(UOrient::horizontal, a);}

USepar& uvsepar(const UArgs& a)
{return *new USepar(UOrient::vertical, a);}


const UStyle& USepar::getStyle(UContext*) const {
  if (orient == UOrient::HORIZONTAL) return makeHStyle();
  else return makeVStyle();
}

UStyle *USepar::hstyle = null;
const UStyle& USepar::makeHStyle() {
  if (!hstyle) {
    hstyle = new UStyle();
    hstyle->orient       = UOrient::HORIZONTAL;
    hstyle->local.halign = UHalign::FLEX;
    hstyle->local.valign = UValign::CENTER;
    hstyle->local.padding.set(0, 0);
    hstyle->local.border = &UBorder::shadowIn;
  }
  return *hstyle;
}

UStyle *USepar::vstyle = null;
const UStyle& USepar::makeVStyle() {
  if (!vstyle) {
    vstyle = new UStyle();
    vstyle->orient   = UOrient::VERTICAL;
    vstyle->local.halign   = UHalign::CENTER;
    vstyle->local.valign   = UValign::FLEX;
    vstyle->local.padding.set(0, 0);
    vstyle->local.border   = &UBorder::shadowIn;
  }
  return *vstyle;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

ULabel::ULabel(const UArgs& a) : UBox(a) {}

UStyle *ULabel::style = null;
const UStyle& ULabel::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->orient         = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::CENTER;
    style->local.padding.set(2, 2);
    style->local.hspacing = 1;
    style->local.vspacing = 1;
  }
  return *style;
}
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UItem::UItem(const UArgs& a): UBox() {
  setCmodes(UMode::CAN_ARM | UMode::ENTER_HIGHLIGHT, true);
  // this object auto opens dialog children because it is ARMable
  // !att: pour que ca marche faut ajouter a APRES!
  addlist(a);
}

UStyle *UItem::style = null;
const UStyle& UItem::makeStyle() {
  if (!style) {
    style = new UStyle();

    style->fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::white);
    style->bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::navy);

    style->setColors(UOn::DISABLED,  UColor::disabled);
    style->setBgcolors(UOn::ENTERED, UBgcolor::lightgrey, true, false);
    style->setBgcolors(UOn::ENTERED, UBgcolor::navy, false, true);

    style->setColors(UOn::ARMED,   UColor::white);
    style->setBgcolors(UOn::ARMED, UBgcolor::blue);

    style->setColors(UOn::DROP_ENTERED,   UColor::white);
    style->setBgcolors(UOn::DROP_ENTERED, UBgcolor::blue);

    //style->setBgcolors(UOn::HIGHLIGHTED, UBgcolor::red);

    style->orient         = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::FLEX;
    style->local.hspacing = 2;
    style->local.hspacing = 2;
    style->local.padding.set(1, 1);
  }
  return *style;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

static void MakeButtonColors(UColor***bgcolors, 
			      UColor***fgcolors, bool transp) {

  *fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::inherit); 
  if (transp)
    //*bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::blue);
    // blue: atroce (6jt03)
    *bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::none);
  else
    *bgcolors = UStyle::makeColors(&UBgcolor::grey, &UBgcolor::grey);

  UStyle::setColor(*fgcolors, UOn::DISABLED,	&UColor::disabled);
  UStyle::setColor(*bgcolors, UOn::ENTERED, 	&UColor::lightgrey);

  UStyle::setColor(*bgcolors, UOn::ARMED, 	&UBgcolor::darkgrey);
  UStyle::setColor(*bgcolors, UOn::DROP_ENTERED,&UColor::darkgrey);
}

static void MakeMenuButtonColors(UColor***bgcolors, 
				 UColor***fgcolors) {

  *fgcolors = UStyle::makeColors(&UColor::inherit,&UColor::inherit); 
  *bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::blue);

  UStyle::setColor(*fgcolors, UOn::DISABLED,	&UColor::darkgrey);
  UStyle::setColor(*fgcolors, UOn::ENTERED, 	&UColor::orange);
  //UStyle::setColor(*fgcolors, UOn::ENTERED, 	&UColor::white);
  //UStyle::setColor(*bgcolors, UOn::ENTERED, 	&UColor::blue);

  UStyle::setColor(*fgcolors, UOn::ARMED, 	&UColor::red);
  //UStyle::setColor(*fgcolors, UOn::ARMED, 	&UColor::white);
  //UStyle::setColor(*bgcolors, UOn::ARMED, 	&UBgcolor::blue);

  UStyle::setColor(*fgcolors, UOn::DROP_ENTERED,&UColor::orange);
  //UStyle::setColor(*fgcolors, UOn::DROP_ENTERED,&UColor::white);
  //UStyle::setColor(*bgcolors, UOn::DROP_ENTERED,&UColor::blue);
}

/* ==================================================== ======== ======= */
// !!ATT: Style Variable suivant Context

UStyle *UButton::style, *UButton::menuStyle, *UButton::barStyle,
  *UButton::flatStyle, *UButton::linkStyle;

const UStyle& UButton::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->orient         = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::CENTER;
    style->local.hspacing = 2;
    style->local.vspacing = 2;
    style->local.padding.set(2, 2);
    MakeButtonColors(&style->bgcolors, &style->fgcolors, false); //opaque
    // style->font           = &UFont::bold;
    // style->local.border= &UBorder::activeShadowOut;
    style->local.border   = &UBorder::shadowOut;
  }
  return *style;
}

const UStyle& UButton::makeMenuStyle() {
  if (!menuStyle) {
    menuStyle = new UStyle();
    menuStyle->orient         = UOrient::HORIZONTAL;
    menuStyle->local.halign   = UHalign::LEFT;
    menuStyle->local.valign   = UValign::CENTER;
    menuStyle->local.hspacing = 2;
    menuStyle->local.vspacing = 2;
    menuStyle->local.padding.set(2, 2);
    MakeMenuButtonColors(&menuStyle->bgcolors, &menuStyle->fgcolors);
    menuStyle->font           = &UFont::bold;
    menuStyle->local.border   = null;
  }
  return *menuStyle;
}

const UStyle& UButton::makeBarStyle() {
  if (!barStyle) {
    barStyle = new UStyle();
    barStyle->orient         = UOrient::VERTICAL;
    barStyle->local.halign   = UHalign::CENTER;
    barStyle->local.valign   = UValign::CENTER;
    barStyle->local.hspacing = 2;
    barStyle->local.vspacing = 2;
    barStyle->local.padding.set(2, 2);
    MakeMenuButtonColors(&barStyle->bgcolors, &barStyle->fgcolors);
    barStyle->local.border   = null;
  }
  return *barStyle;
}

const UStyle& UButton::makeFlatStyle() {
  if (!flatStyle) {
    flatStyle = new UStyle();
    flatStyle->orient         = UOrient::HORIZONTAL;
    flatStyle->local.halign   = UHalign::LEFT;
    flatStyle->local.valign   = UValign::CENTER;
    flatStyle->local.hspacing = 2;
    flatStyle->local.vspacing = 2;
    flatStyle->local.padding.set(1, 1);
    MakeButtonColors(&flatStyle->bgcolors, &flatStyle->fgcolors, true); // transp
    // flatStyle->font           = &UFont::bold;
    flatStyle->local.border   = &UBorder::flat;
    // flatStyle->local.alpha = 0.66;
  }
  return *flatStyle;
}

const UStyle& UButton::makeLinkStyle() {
  if (!linkStyle) {
    linkStyle = new UStyle();
    linkStyle->orient         = UOrient::HORIZONTAL;
    linkStyle->local.halign   = UHalign::LEFT;
    linkStyle->local.valign   = UValign::CENTER;
    linkStyle->local.hspacing = 1;
    linkStyle->local.vspacing = 1;
    linkStyle->local.padding.set(1, 1);
    // NB bleu sur fond qq
    linkStyle->fgcolors = UStyle::makeColors(&UColor::navy, &UColor::red);
    linkStyle->bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::none);
    linkStyle->setColors(UOn::DISABLED,  UColor::disabled);
    linkStyle->setBgcolors(UOn::ENTERED, UBgcolor::grey);

    linkStyle->setColors(UOn::ARMED,     UColor::red);
    linkStyle->setColors(UOn::DROP_ENTERED,  UColor::blue);
    linkStyle->setColors(UOn::ACTIONED,  UColor::red);
 
    linkStyle->local.border = null;
    linkStyle->cursor = &UCursor::hand;
    linkStyle->font   = &UFont::underline;
  }
  return *linkStyle;
}

/* ==================================================== ======== ======= */

const UStyle& UButton::getStyle(UContext* ctx) const {
  if (ctx && ctx->parent_box) {
    // style for menus and menubar
    if (dynamic_cast<const UMenu*>(ctx->parent_box) 
	|| dynamic_cast<const UMenubar*>(ctx->parent_box))
      return makeMenuStyle();
    
    // style for bars
    else if (dynamic_cast<const UBar*>(ctx->parent_box))
      return makeBarStyle();
  } //endif (parent) 
  

  // tous les autres cas : standard style
  return makeStyle();
}

/* ==================================================== ======== ======= */

UButton::UButton(const UArgs& a) : UBox() {
  setCmodes(UMode::CAN_ARM | UMode::ENTER_HIGHLIGHT, true);
  // this object auto opens dialog children because it is ARMable
  // !att: pour que ca marche faut ajouter a APRES!
  addlist(a);
}

UFlatbutton::UFlatbutton(const UArgs& a) : UButton(a) {}

ULinkbutton::ULinkbutton(const UArgs& a) : UButton(a) {
  // le style suffit pas !
  setCmodes(UMode::HAS_CURSOR, true);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UCheckbox::style, *UCheckbox::barStyle, *UCheckbox::menuStyle;

UCheckbox::UCheckbox(const UArgs& a) : UBox() {
  setCmodes(UMode::CAN_ARM | UMode::CAN_SELECT | UMode::ENTER_HIGHLIGHT, true);
  // this object auto opens dialog children because it is ARMable
  // !att: pour que ca marche faut ajouter a APRES!
  addlist(a);
} 

const UStyle& UCheckbox::getStyle(UContext*ctx) const {
  if (ctx && ctx->parent_box) {
    
    if (dynamic_cast<const UMenu*>(ctx->parent_box)
  	|| dynamic_cast<const UMenubar*>(ctx->parent_box)) {  
      if (!menuStyle) {
	menuStyle = new UStyle(UButton::makeMenuStyle());
	// add the check symbol
	menuStyle->local.content = &ugroup(USymbol::check);
      }
      return *menuStyle;
    }

    else if (dynamic_cast<const UBar*>(ctx->parent_box)) {
      if (!barStyle) {
	barStyle = new UStyle(UButton::makeBarStyle());
	barStyle->orient  = UOrient::HORIZONTAL;
	barStyle->local.content = &ugroup(USymbol::check);
      }
      return *barStyle;
    }
  } //endif (parent) 

  // tous les autres cas : standard style
  if (!style) {
    style = new UStyle(UButton::makeStyle());
    style->local.border = null;
    // add the check symbol
    style->local.content = &ugroup(USymbol::check);    
  }
  return *style;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *UTextbox::style = null;
const UStyle& UTextbox::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::white);
    style->bgcolors = UStyle::makeColors(&UBgcolor::none, &UBgcolor::black);

    style->setColors(UOn::DISABLED,      UColor::disabled);
    style->setBgcolors(UOn::DROP_ENTERED,UBgcolor::blue);
    //style->setBgcolors(UOn::HIGHLIGHTED, UBgcolor::red);

    style->orient = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::LEFT;
    style->local.valign   = UValign::CENTER;
    style->local.hspacing = 0;
    style->local.vspacing = 3;
    style->local.padding.set(2, 3);
    style->local.border   = &UBorder::shadowIn;
    style->cursor         = &UCursor::text;

    // keep initial size and don't change it when children are added/removed
    // (but size can be changed by user interaction and/or uvflex())
    style->local.height = UHeight::KEEP_SIZE;
    style->local.width  = UWidth::KEEP_SIZE;
  }
  return *style; 
}


UTextbox::UTextbox(const UArgs& a) : UBox(a) {
  //setBmodes(UMode::MOUSE_CB, true);
  setCmodes(UMode::CAN_SELECT_TEXT // also added by uedit
	    | UMode::HAS_CURSOR, true);
  setCmodes(UMode::HAS_CLOSE_MENU_MODE, true);
  setCmodes(UMode::CLOSE_MENU_MODE, false);
}

/* ==================================================== ======== ======= */

UTextfield::UTextfield(const UArgs& a) : 
  UTextbox(a),
  pedit(new UEdit())
{
  addAttr(UBgcolor::white);
  addAttr(*pedit);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UChoice& UCombobox::choice() {return plist->choice();}
const UChoice& UCombobox::choice() const {return plist->choice();}

UCombobox::UCombobox(class UListbox& _list, const UArgs& _a) :
UTextfield(_a),
plist(_list),
text_only(false)
{
  UBorder* border = new UBorder
    (
     false,          // NOT overlaid sinon le caret passe dessous!
     UValign::flex + UHalign::right
     + uitem(USymbol::down + ucall(this, &UCombobox::openMenu))
     );
  addAttr(border);
  addAttr(uvcenter());

  pentry = new UGroup();
  pmenu = upopmenu(*plist);
  addlist(*pentry + *pmenu);

  plist->addAttr(UBorder::none);   // virer le border: horrible dans un menu
  plist->choice().onChange(ucall(this, true, true, &UCombobox::changed));

  // first element of the list will be the pcurrent (if it exists)
  //plist->choice().setIndex(0);  // FAUX: appelle les callbacks
  changed(true, false);
}

void UCombobox::openMenu(UEvent& e) {
  UView* combo_view = e.getView() ? e.getView()->getParentView() : null;
  if (combo_view) {
    pmenu->move(combo_view, 0, combo_view->getHeight());
    pmenu->open();
  }
}

void UCombobox::setTextMode(bool st) {
  text_only = st;
  changed(true, false);
}

void UCombobox::changed(bool upd, bool call_cb) {
  pentry->removeAll(false, false);

  if (choice().getItem()) {
    UListPos lpos;
    UBrick* child;
    
    while ((child = choice().getItem()->getChild(lpos))) {
      UStr* s = dynamic_cast<UStr*>(child);

      if (s) pentry->add(new UStr(*s), false);
      else if (!text_only) pentry->add(child, false);
      }
  }

  if (upd) pentry->update();

  // devrait aussi lancer UOn::change !!!!!!!!!!!!!!!
  // UOn::action devrait aussi etre execute si pas change !!!!

  if (call_cb) {
    UEvent e(UEvent::action, null, null, NULL);
    e.setSource(this);
    fire(e, UOn::action);
  }
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle* UListbox::style = null;
const UStyle& UListbox::makeStyle() {
  if (!style) {
    style = new UStyle();

    style->fgcolors = UStyle::makeColors(&UColor::inherit, &UColor::white);
    style->bgcolors = UStyle::makeColors(&UBgcolor::white, &UBgcolor::black);

    style->setColors(UOn::DISABLED,     UColor::disabled);
    //style->setBgcolors(UOn::HIGHLIGHTED, UBgcolor::red);

    style->orient = UOrient::VERTICAL;
    style->local.halign   = UHalign::FLEX;
    style->local.valign   = UValign::TOP;
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    // il faut de l'espace autour des listes pour le scroll
    style->local.padding.set(5, 4);
    style->local.border   = &UBorder::shadowIn;
  }
  return *style; 
}

/* ==================================================== ======== ======= */

UListbox::UListbox(const UArgs& a) :
UBox(),
pchoice(new UChoice(this)),
callbacks(ucall(this, &UListbox::mouseCB))
{
  addAttr(*pchoice);
  setCmodes(/*UMode::ENTER_HIGHLIGHT provoque un flicking d'enfer|*/
            UMode::CAN_BROWSE_CHILDREN, true);
  onPostChildEvent(UOn::mpress / callbacks
                   + UOn::mrelease / callbacks
		   + UOn::select   / callbacks
		   + UOn::unselect / callbacks
                   );
  // APRES addAttr(*pchoice) !
  addlist(a);
}

/* ==================================================== ======== ======= */

void UListbox::mouseCB(UEvent& e) {
  if (e.getID() == UEvent::mpress) 
    e.getFlow()->setBrowsingGroup(this);

  else if (e.getID() == UEvent::mrelease)
    e.getFlow()->setBrowsingGroup(null);

  // on n'est pas cense selectionner le listbox lui-meme
  if (!e.getSource() || e.getSource() == this) return;
  
  if (e.getCond() == &UOn::select) {

    // voir comment fait pour combo
    // devrait aussi lancer UOn::change !

    UGroup* target = pchoice->itemChanged(e);
    //e.setID(UEvent::select);
    //fire(e, UOn::select);    // fait dans USelect::changed
    e.setID(UEvent::action);
    e.setAux(target);
    fire(e, UOn::action);
  }

  else if (e.getCond() == &UOn::unselect) {
    UGroup* target = pchoice->itemChanged(e);
    //e.setID(UEvent::unselect); 
    //fire(e, UOn::select);     // fait dans USelect::changed
    e.setID(UEvent::action);
    e.setAux(target);
    fire(e, UOn::action);
  }
}

/* ==================================================== ======== ======= */
// UStr(s) are *NOT* duplicated.

UListbox& UListbox::addItem(UStr* s) {
  if (s) add(uitem(s));
  return *this;
}

UListbox&  UListbox::addItems(const std::vector<UStr*>& tab) {
  for (unsigned int k = 0; k < tab.size(); k++)
    if (tab[k]) add(uitem(tab[k]));
  return *this;
}

UListbox&  UListbox::addItems(const UArgs& prefix, const std::vector<UStr*>& tab) {
  for (unsigned int k = 0; k < tab.size(); k++)
    if (tab[k]) add(uitem(prefix + tab[k]));
  return *this;
}

/* ==================================================== ======== ======= */
// char strings *ARE* duplicated.

UListbox&  UListbox::addItem(const char* s) {
  if (s) add(uitem(ustr(s)));
  return *this;
}

UListbox&  UListbox::addItems(const char* tab[]) {
  for (unsigned int k = 0; tab[k] != null ; k++)
    add(uitem(ustr(tab[k])));
  return *this;
}

UListbox&  UListbox::addItems(const UArgs& prefix, const char* tab[]) {
  for (unsigned int k = 0; tab[k] != null ; k++)
    add(uitem(prefix + ustr(tab[k])));
  return *this;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UStyle *USpinbox::style = null;
const UStyle& USpinbox::makeStyle() {
  if (!style) style = new UStyle(UBox::makeStyle());
  return *style;
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

USpinbox::USpinbox(const UArgs& a) : 
  UBox(),
  pvalue(*new UIntg(0)),
  pincrement(*new UIntg(1)),
  pstr(*new UStr()) {
  constructs(a);
}

USpinbox::USpinbox(UIntg& _value, const UArgs& a) : 
  UBox(),
  pvalue(_value),
  pincrement(*new UIntg(1)),
  pstr(*new UStr()) {
  constructs(a);
}

USpinbox::USpinbox(UIntg& _value, UIntg& _increment, const UArgs& a) : 
  UBox(),
  pvalue(_value),
  pincrement(_increment),
  pstr(*new UStr()) {
  constructs(a);
}

/* ==================================================== ======== ======= */

void USpinbox::constructs(const UArgs& a) {
  textbox.addlist
    (
     UBgcolor::white
     + uedit()
     + UOn::action / ucall(this, 0, &USpinbox::updateValue)
     + UOn::leave  / ucall(this, 0, &USpinbox::updateValue)
     );
  textbox.addlist(a); // ??
  textbox.add(*pstr);

  pstr->set(*pvalue);
  pstr->append("        ");

  // value change -> mise a jour de la string
  pvalue->onChange(ucall(this, &USpinbox::valueChanged));

  addlist
    (
     uhflex()
     + textbox
     + uright()
     + uvbox(uvcenter() + uhcenter()
	     + ubox(USymbol::up   + UOn::arm/ucall(this,+1,&USpinbox::updateValue))
	     + ubox(USymbol::down + UOn::arm/ucall(this,-1,&USpinbox::updateValue))
	     )
     );
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

void USpinbox::updateValue(int dir) {
  if (dir == 0) pvalue->set(*pstr);  // transform string to num value
  // ajouter ou retrancher increment 
  else if (dir > 0) pvalue->incr(*pincrement);
  else if (dir < 0) pvalue->decr(*pincrement);
}

void USpinbox::valueChanged() {
  pstr->set(*pvalue);  // reset string format

  //UEvent e(UEvent::action,  null, null, NULL);
  UEvent e(UEvent::change,  null, null, NULL);
  e.setSource(this);
  //e.setAux(*pvalue);   //??
  fire(e, UOn::action);
}

void USpinbox::setValue(const UIntg& a)     {pvalue->set(a);}
void USpinbox::setIncrement(const UIntg& a) {pincrement->set(a);}
void USpinbox::setStr(const UStr& s)        {pstr->set(s);}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UAlertbox::UAlertbox(const UArgs& args) {
  addlist
  (
   UBgcolor::white + ualpha(0.6)
   + uhcenter() + uvcenter()
   + args
   + UFont::bold + UFont::large
   + uhbox(uscale(+2) + UFont::xx_large
	   + UPix::ray + UColor::red + " Alert! ")
   + " "
   + " "
   + uhflex()
   + uflowbox(UFont::large + UColor::navy + message)
   + "  "
   + "  "
   + uhcenter()
   + ubutton(uscale(+1) + UFont::x_large + ualpha(0.6) 
	     + UPix::check + " Close " + ushow(this, false))
   );
}

void UAlertbox::show(bool state) {
UBox::show(state);
}

void UAlertbox::show(const UStr& mesg) {
  message.removeAll();
  message.add(ustr(mesg));
  update();
  UBox::show(true);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

