#include <iostream>
#include "ubit/ubit.hpp"
using namespace std;


void foo(const char* msg, UStr* str) {
  cout <<"Event: " << msg << " / chars=[" << str->chars() << "]" << endl;
}


int main(int argc, char *argv[]) {
  UAppli appli(&argc, argv);

  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

  // simple editable text field with callbacks

  UStr& str = ustr();

  // will be called when the string content is changed
  str.onChange( ucall("onChange", &str, foo) );

  UBox& part1 = uvbox
    (
     UBorder::etchedIn + uhmargin(4) + uvmargin(4) 
     + ulabel("Simple editable text field with Callbacks")

     + utextbox(UBgcolor::white + uedit() 
		// will be called when the string content is changed
		+ UOn::strChange / ucall("UOn::strChange", &str, foo)

		// will be called when the Enter/Return key is pressed
		+ UOn::action / ucall("UOn::action", &str, foo)

		+ UFont::large + UColor::navy
		+ str
		)
     );


  // multi-colored multi-font editable text

  UBox& part2 = uvbox
    (
     UBorder::etchedIn + uhmargin(4) + uvmargin(4) 
     + ulabel("Multi-colored multi-font editable text")

     + utextbox(UBgcolor::white + uedit()
		+ UFont::large 
		+"xyz" 
		+ UColor::orange + UFont::bold + "abcd" + UFont::_bold
		+ UColor::blue + "1234" 
		)
     );


  // multi-line warped text

  UBox& part3 = uvbox
    (
     UBorder::etchedIn + uhmargin(4) + uvmargin(4) 
     + ulabel("Multi-line warped text containing various objects")

     + uflowbox(uedit()
		// we must specify the size of the text area
		+ uheight(130)
		+ UBgcolor::white
		+ uhmargin(2) + uvmargin(2) 
		+ UFont::large 
		+ "xyz"
		+ UColor::orange + UFont::bold + "abcd" + UFont::_bold
		+ UColor::blue + "1234\n"
		+ UColor::navy
		+ UPix::diskette + UPix::check + UPix::cross + UPix::select
		+ UFont::italic + "Multi-line warped text" + UFont::_italic
		+ UPix::question + "\n"
		+ UColor::black
		+ " " + ulinkbutton("pseudo-link")
		+ " " + utextbox(uedit() + UFont::small + "internal textbox") 
		+ ucheckbox(UFont::medium + "checkbox") + "\n\n"
		+ UColor::orange
		+ UFont::overline + "Overline" + UFont::_overline+ " "
		+ UColor::green
		+ UFont::strikethrough + "strikethrough" + UFont::_strikethrough + " "
		+ UColor::black
		+ UFont::underline + "underline" + UFont::_underline
		)
     );


  // Multi-line warped text in a Scrollpane

  UBox& part4 = uvbox
    (
     UBorder::etchedIn + uhmargin(4) + uvmargin(4) 
     + ulabel("Multi-line warped text in a Scrollpane")
     + uvflex()

     + uscrollpane( // we must specify the size of the scroll pane
		   uheight(130) 
		   + uflowbox(uedit()
			      + UBgcolor::white
			      + uhmargin(2) + uvmargin(2) 
			      + UFont::large 
			      + "xyz"
			      + UColor::orange + UFont::bold + "abcd" + UFont::_bold
			      + UColor::blue + "1234"
			      )
		   )
     );
  
  
  UFrame& frame = uframe
    (
     uwidth(400) 
     + uhmargin(10) + uvmargin(10) + uvspacing(10)
     + utop() 
     + part1
     + part2
     + uvflex() // following objects flexible in the vertical direction
     + part3
     + part4
     );
  
  // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

  appli.add(frame);
  frame.show(true);
  return appli.mainLoop();
}


