/*
 * HypBrowser: part of Ubit demos
 * Franck Shen - Cedric Timsit. 2003
 */
#include "hbrowser.hpp"
#include "hnode.hpp"


void OpenDir(UFilebox& openbox, HBrowser& hyb) {
  hyb.openDir(openbox.getDir());
}

int main(int argc, char **argv) {
  UAppli app(argc, argv);
  UFrame mainframe;

  HBrowser hyb((argc > 1 ? argv[1] : "."), uwidth(450) + uheight(450));

  UFilebox openbox;
  openbox.addlist(ucallref(openbox, hyb, OpenDir));
    
  UBar controls
    (
     uhflex()
     + ulabel( "Directory: " + hyb.currentpath
	      + " - " + hyb.nodecount_str  + " nodes")
     + uright()
     //+ UFont::bold
     //+ ubutton( UOrient::horizontal
     //           + USymbol::up + "Up " + ucall(&hyb, &HBrowser::up))
     + ubutton( UOrient::horizontal
                + UPix::folder + "Open" + udialog(openbox))
     + ubutton( UOrient::horizontal
                + UPix::ray + "Quit" + ucall(0, &UAppli::quit))
     + " "
     );

  mainframe.addlist( uvflex() + hyb + ubottom() + controls );

  app.add(mainframe);
  mainframe.show();
  return app.mainLoop();
}
