/* ==================================================== ======== ======= *
 *
 *  uobs.hh  //OBSOLETE CLASSES & FUNCTIONS
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:99] ======= *
 * ==================================================== ======== ======= */

#ifndef _uobs_hh
#define	_uobs_hh

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// OBSOLETE: bientot a la poubelle !!!

class UFloating: public UBoxLink {
  friend class UBox;
protected:
  u_pos rx, ry;
public:
  UFloating(UBox*);
  UFloating(int x, int y, UBox*);

  // dynamic cast
  virtual class UFloating* floatingCast() {return this;}

  //set the Floating child if it was created with a null argument
  //!beware: this function can only be used for intializing the UFloating
  //!it will have no effect afterwards
  void init(UBox*);
  void init(UBox&);

  // return the location of the UFloating relatively to its PARENT
  virtual u_pos getX();
  virtual u_pos getY();
  virtual void where(u_pos *x, u_pos *y);

  // changes the location of the UFloating relatively to its PARENT
  virtual void setX(u_pos x);
  virtual void setY(u_pos y);
  virtual void move(u_pos x, u_pos y);

  //package_private: ====[Ubit Intrinsics]==============================
  void _setX(u_pos x); // NO AUTOMATIC UPDATE
  void _setY(u_pos y); // NO AUTOMATIC UPDATE
};

// (X,Y) are relative coordonates (see comment above)
UFloating& ufloating(UBox&);
UFloating& ufloating(UBox*);
UFloating& ufloating(int x, int y, UBox&);
UFloating& ufloating(int x, int y, UBox*);

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// uset() callbacks
// -- NOTE: the 'objcet' given as an argument must (of course!)
// have an appropriate 'set' method (with the same 'a1' argument)

template <class CC, class ARG1> class USetMethod : public UCall {
  CC *obj;
  ARG1 arg1;
public:
  USetMethod(CC *object, ARG1 a1, UOn &cond)
    : UCall(cond) {obj = object; arg1 = a1;}
  void call(UEvent*) {obj->set(arg1);}
};


// METHOD PROTOTYPE:  void MyClass::set(MyClass2* value);
// OR:                void MyClass::set(const MyClass2* value);
// USET SYNTAX:
//              MyClass object;
//              MyClass2 value;  // (usually MyClass == MyClass2)
//
//              uset(&object,  &value, UOn::condition)

template <class CC, class ARG1> 
UCall& uset(CC *object, ARG1 a1, UOn &cond) {
  return *(new USetMethod<CC,ARG1> (object, a1, cond));
}

/*** does not work with g++ 2.95.2
template <class CC, class ARG1> 
UCall& usetr(CC &object, ARG1 a1, UOn &cond) {
  return *(new USetMethod<CC,ARG1> (&object, a1, cond));
}
***/


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback METHOD with NO argument:
// --  void foo()


template <class CC> class UCallMethod_0a : public UCall {
  CC *obj;
  void (CC::*member)();
public:
  UCallMethod_0a( CC *object, void (CC::*m)(), UOn &cond )
    : UCall(cond) {obj = object; member = m;}
  void call(UEvent *e) {(obj->*member)();}
};


// METHOD PROTOTYPE:  void MyClass::foo()
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, UOn::condition)
// OR:                ucall(&object, &MyClass::foo, UOn::condition)
template <class CC> 
UCall& ucall(CC *object, void (CC::*method)(), UOn &cond) {
  return *(new UCallMethod_0a<CC>(object, method, cond));
}

template <class CC> 
UCall& ucall(CC &object, void (CC::*method)(), UOn &cond) {
  return *(new UCallMethod_0a<CC>(&object, method, cond));
}


/* ==================================================== ======== ======= */
// Callback METHOD with UEvent* and NO argument:
// --  void foo( UEvent* )


template <class CC> class UCallMethod_e0a : public UCall {
  CC *obj;
  void (CC::*member)(UEvent*);
public:
  UCallMethod_e0a( CC *object, void (CC::*m)(UEvent*), UOn &cond )
    : UCall(cond) {obj = object; member = m;}
  void call(UEvent *e) {(obj->*member)(e);}
};


// METHOD PROTOTYPE:  void MyClass::foo(UEvent*)
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, UOn::condition)
// OR:                ucall(&object, &MyClass::foo, UOn::condition)
//
template <class CC> 
UCall& ucall(CC *object, void (CC::*method)(UEvent*), UOn &cond) {
  return *(new UCallMethod_e0a<CC>(object, method, cond));
}

template <class CC> 
UCall& ucall(CC &object, void (CC::*method)(UEvent*), UOn &cond) {
  return *(new UCallMethod_e0a<CC>(&object, method, cond));
}


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback METHOD with ONE argument: 
// --  void foo( ARG1 arg1 )


template <class CC, class ARG1> class UCallMethod_1a : public UCall {
  CC *obj;
  void (CC::*member)(ARG1);
  ARG1 arg1;
public:
  UCallMethod_1a( CC *object, void (CC::*m)(ARG1),
		   ARG1 a1, UOn &cond)
    : UCall(cond) {obj = object; member = m; arg1 = a1;}
  void call(UEvent*) {(obj->*member)(arg1);}
};


// METHOD PROTOTYPE:  void MyClass::foo(ARG1 arg1)
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, arg1, UOn::cond)
// OR:                ucall(&object, &MyClass::foo, arg1, UOn::cond)
//
template <class CC, class ARG1> 
UCall& ucall(CC *object, void (CC::*method)(ARG1), ARG1 a1, UOn &cond) {
  return *(new UCallMethod_1a<CC,ARG1> (object, method, a1, cond));
}

template <class CC, class ARG1> 
UCall& ucall(CC &object, void (CC::*method)(ARG1), ARG1 a1, UOn &cond) {
  return *(new UCallMethod_1a<CC,ARG1> (&object, method, a1, cond));
}


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback METHOD with UEvent* and ONE argument:  
// --  void foo( UEvent*, ARG1 a1 )


template <class CC, class ARG1> class UCallMethod_e1a : public UCall {
  CC *obj;
  void (CC::*member)(UEvent*, ARG1);
  ARG1 arg1;
public:
  UCallMethod_e1a( CC *object, void (CC::*m)(UEvent*,ARG1),
		   ARG1 a1, UOn &cond)
    : UCall(cond) {obj = object; member = m; arg1 = a1;}
  void call(UEvent *e) {(obj->*member)(e, arg1);}
};


// METHOD PROTOTYPE:  void MyClass::foo(UEvent*, ARG1 arg1)
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, arg1, UOn::cond)
// OR:                ucall(&object, &MyClass::foo, arg1, UOn::cond)
//
template <class CC, class ARG1> 
UCall& ucall(CC *object, void (CC::*method)(UEvent*,ARG1), 
	     ARG1 a1, UOn &cond) {
  return *(new UCallMethod_e1a<CC,ARG1> (object, method, a1, cond));
}

template <class CC, class ARG1> 
UCall& ucall(CC &object, void (CC::*method)(UEvent*,ARG1), 
	     ARG1 a1, UOn &cond) {
  return *(new UCallMethod_e1a<CC,ARG1> (&object, method, a1, cond));
}


/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */
// Callback METHOD with TWO arguments:
// --  void foo( ARG1 a1, ARG2 a2 )


template <class CC, class ARG1, class ARG2> class UCallMethod_2a : public UCall {
  CC *obj;
  void (CC::*member)(ARG1, ARG2);
  ARG1 arg1;
  ARG2 arg2;
public:
  UCallMethod_2a( CC *object, void (CC::*m)(ARG1, ARG2), 
		   ARG1 a1, ARG2 a2, UOn &cond)
    : UCall(cond) {obj = object; member = m; arg1 = a1; arg2 = a2;}
  void call(UEvent *e) {(obj->*member)(arg1, arg2);}
};


// METHOD PROTOTYPE:  void MyClass::foo(UEvent*, ARG1 arg1, ARG2 arg2)
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, arg1, arg2, UOn::cond)
// OR:                ucall(&object, &MyClass::foo, arg1, arg2, UOn::cond)
//
template <class CC, class ARG1, class ARG2> 
UCall& ucall(CC *object, void (CC::*method)(ARG1, ARG2), 
	     ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallMethod_2a<CC,ARG1,ARG2> (object, method, a1, a2, cond));
}

template <class CC, class ARG1, class ARG2> 
UCall& ucall(CC &object, void (CC::*method)(ARG1, ARG2), 
	     ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallMethod_2a<CC,ARG1,ARG2> (&object, method, a1, a2, cond));
}


/* ==================================================== [Elc:99] ======= */
/* ==================================================== ======== ======= */
// Callback METHOD with UEvent* and TWO arguments:
// --  void foo( UEvent*, ARG1 a1, ARG2 a2 )


template <class CC, class ARG1, class ARG2> class UCallMethod_e2a : public UCall {
  CC *obj;
  void (CC::*member)(UEvent*, ARG1, ARG2);
  ARG1 arg1;
  ARG2 arg2;
public:
  UCallMethod_e2a( CC *object, void (CC::*m)(UEvent*,ARG1,ARG2), 
		   ARG1 a1, ARG2 a2, UOn &cond)
    : UCall(cond) {obj = object; member = m; arg1 = a1; arg2 = a2;}
  void call(UEvent *e) {(obj->*member)(e, arg1, arg2);}
};


// METHOD PROTOTYPE:  void MyClass::foo(UEvent*, ARG1 arg1, ARG2 arg2)
// UCALL SYNTAX:      ucall(object,  &MyClass::foo, arg1, arg2, UOn::cond)
// OR:                ucall(&object, &MyClass::foo, arg1, arg2, UOn::cond)
//
template <class CC, class ARG1, class ARG2> 
UCall& ucall(CC *object, void (CC::*method)(UEvent*,ARG1,ARG2), 
	     ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallMethod_e2a<CC,ARG1,ARG2> (object, method, a1, a2, cond));
}

template <class CC, class ARG1, class ARG2> 
UCall& ucall(CC &object, void (CC::*method)(UEvent*,ARG1,ARG2), 
	     ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallMethod_e2a<CC,ARG1,ARG2> (&object, method, a1, a2, cond));
}


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback FUNCTION with ONE argument:
// --  void foo( ARG1 arg1 )


template <class ARG1> class UCallFun_1a : public UCall {
  void (*fun)(ARG1);
  ARG1 arg1;
public:
  UCallFun_1a(void (*f)(ARG1), ARG1 a1, UOn &cond)
    : UCall(cond) {fun = f; arg1 = a1;}
  void call(UEvent *e) {(*fun)(arg1);}
};


// FUNCTION PROTOTYPE:  void foo(ARG1 arg1)
// UCALL SYNTAX:        ucall(&foo, arg1, UOn::cond)
//
template <class ARG1> 
UCall& ucall( void (*f)(ARG1), ARG1 a1, UOn &cond) {
  return *(new UCallFun_1a<ARG1> (f, a1, cond));
}


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback FUNCTION with UEvent* and ONE argument:
// --  void foo( UEvent*, ARG1 arg1 )


template <class ARG1> class UCallFun_e1a : public UCall {
  void (*fun)(UEvent*, ARG1);
  ARG1 arg1;
public:
  UCallFun_e1a(void (*function)(UEvent*,ARG1), ARG1 a1, UOn &cond)
    : UCall(cond) {fun = function; arg1 = a1;}
  void call(UEvent *e) {(*fun)(e, arg1);}
};


// FUNCTION PROTOTYPE:  void foo(UEvent*, ARG1 arg1)
// UCALL SYNTAX:        ucall(&foo, arg1, UOn::cond)
//
template <class ARG1> 
UCall& ucall( void (*function)(UEvent*,ARG1), ARG1 a1, UOn &cond) {
  return *(new UCallFun_e1a<ARG1> (function, a1, cond));
}

/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback FUNCTION with TWO arguments
// --  void foo( UEvent*, ARG1 arg1, ARG2 arg2 )


template <class ARG1, class ARG2> class UCallFun_2a : public UCall {
  void (*fun)(ARG1, ARG2);
  ARG1 arg1;
  ARG2 arg2;
public:
  UCallFun_2a( void (*f)(ARG1,ARG2), ARG1 a1, ARG2 a2, UOn &cond)
    : UCall(cond) {fun = f; arg1 = a1; arg2 = a2;}
  void call(UEvent *e) {(*fun)(arg1, arg2);}
};


// FUNCTION PROTOTYPE:  void foo(ARG1 arg1, ARG2 arg2)
// UCALL SYNTAX:        ucall(&foo, arg1, arg2, UOn::cond)
//
template <class ARG1, class ARG2> 
UCall& ucall( void (*f)(ARG1,ARG2), ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallFun_2a<ARG1,ARG2> (f, a1, a2, cond));
}


/* ==================================================== [Elc:00] ======= */
/* ==================================================== ======== ======= */
// Callback FUNCTION with TWO arguments
// --  void foo( UEvent*, ARG1 arg1, ARG2 arg2 )


template <class ARG1, class ARG2> class UCallFun_e2a : public UCall {
  void (*fun)(UEvent*, ARG1, ARG2);
  ARG1 arg1;
  ARG2 arg2;
public:
  UCallFun_e2a( void (*f)(UEvent*,ARG1,ARG2), ARG1 a1, ARG2 a2, UOn &cond)
    : UCall(cond) {fun = f; arg1 = a1; arg2 = a2;}
  void call(UEvent *e) {(*fun)(e, arg1, arg2);}
};


// FUNCTION PROTOTYPE:  void foo(UEvent*, ARG1 arg1, ARG2 arg2)
// UCALL SYNTAX:        ucall(&foo, arg1, arg2, UOn::cond)
//
template <class ARG1, class ARG2> 
UCall& ucall( void (*f)(UEvent*,ARG1,ARG2), ARG1 a1, ARG2 a2, UOn &cond) {
  return *(new UCallFun_e2a<ARG1,ARG2> (f, a1, a2, cond));
}

#endif

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:99] ======= */
