(* TyXML
 * http://www.ocsigen.org/tyxml
 * Copyright (C) 2013 Gabriel Radanne <drupyog+caml@zoho.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, with linking exception;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Suite 500, Boston, MA 02111-1307, USA.
 *)


module type T = sig
  type 'a t
  val bind : 'a t -> ('a -> 'b t) -> 'b t
  val return : 'a -> 'a t
  val fmap : ('a -> 'b) -> 'a t -> 'b t
  val fmap2 :
    ('a -> 'b -> 'c) -> 'a t -> 'b t -> 'c t
  val fmap3 :
    ('a -> 'b -> 'c -> 'd) -> 'a t -> 'b t -> 'c t -> 'd t
  val fmap4 :
    ('a -> 'b -> 'c -> 'd -> 'e) -> 'a t -> 'b t -> 'c t -> 'd t -> 'e t
  val fmap5 :
    ('a -> 'b -> 'c -> 'd -> 'e -> 'f) -> 'a t -> 'b t -> 'c t -> 'd t -> 'e t -> 'f t
end

module NoWrap = struct
  type 'a t = 'a
  external return : 'a -> 'a = "%identity"
  let bind x f = f x
  let fmap f :  'a t -> 'b t = f
  let fmap2 f : 'a t -> 'b t -> 'c t
    = f
  let fmap3 f : 'a t -> 'b t -> 'c t -> 'd t
    = f
  let fmap4 f : 'a t -> 'b t -> 'c t -> 'd t -> 'e t
    = f
  let fmap5 f : 'a t -> 'b t -> 'c t -> 'd t -> 'e t -> 'f t
    = f

end
