<p>The mailbox view is the first page to come up in the mail feature.  It
shows a list of messages in the current folder and provides ways of
managing that mail.</p>

<p>On the left-hand side, near the top of the page, there is menu to select
which mail folder to view.  Folders provide a way of organizing saved
emails.  The default folder is generally called INBOX.  All new mail
should show up in this folder.  To view the contents of another folder,
select that folder from the list and click the "<?php echo $TWIGphrase["Go"] ?>"
button next to the folder list.</p>

<p>Next to the folder list are various mail commands.  The first of these
is "<?php echo $TWIGphrase["New Message"] ?>".  Clicking on this link will
allow you to compose an email message.  See <?php echo TWIGlink( "Writing Email", "help", "mail", "subtopic=compose") ?> for more help on composing email.</p>

<p>Next there is the "<?php echo $TWIGphrase["Prefs"] ?>" link.  This will
bring up the mail preferences page, from which various mail related
options can be set.  See <?php echo TWIGlink( "Mail Preferences", "help", "mail", "subtopic=prefs") ?> for more information.</p>

<p>Next is the "<?php echo $TWIGphrase["Refresh"] ?>" link.  Clicking here
will update the mailbox view to show any new messages or other changes
which may have taken place since the page was last loaded.  The mailbox
view is not updated automatically when new mail arrives, but you may click
on this link to load an updated mailbox view. <b>Please do not use your
web browser's refresh button!</b>  You may inadvertently send multiple
copies of email messages if you do this!</p>

<p>The final command on this line is <?php echo $TWIGphrase["Empty Trash"] ?>.  Use this link to permanently delete
all messages marked for deletion.</p>

<p>Under all of this is the list of messages in the current mailbox.  If
the number of messages is greater than the pagesize value set in <?php echo TWIGlink( "Mail Preferences", "help", "mail", "subtopic=prefs") ?>,
then only part of the message list will be shown and you will see a set of
tabs or arrows which may be used to scroll through the list of
messages.</p>

<p>In the folder list there are four columns.  The first column is labeled
"<?php echo $TWIGphrase["Status"] ?>" and shows icons depicting the
current state of each message.  There are 
<?php
 if (!( TWIGCheckACL( $login["username"], 4009, TWIGConvertAccess( "read" ) ) ))
  {
  echo "two";
  } else {
  echo "three";
  }
?>
 icons in the
<?php echo $TWIGphrase["Status"] ?> column.  The first of these shows
whether or not a message has been read.
The <?php echo TWIGImage( $img["unread"] ); ?>"> icon marks the message as unread.
Clicking on this icon will allow you to read the message.  See <?php echo TWIGlink( "Reading Email", "help", "mail", "subtopic=msgview") ?> for more information.
The <?php echo TWIGImage( $img["read"] ); ?>"> icon indicates that the
message has been read.  Clicking on this icon will toggle the status of
the message back to unread.  This is useful for reminding yourself to re-read
the message latter.
</p>

<p>The second status icon shows whether or not the message has been
marked for deletion.  If the <?php echo TWIGImage( $img["deleted"] ); ?>"> icon appears
in this column, then the message is marked for deletion and will be
deleted when you click on <?php echo $TWIGphrase["Empty Trash"] ?> in the command bar.  If
the <?php echo TWIGImage( $img["undeleted"] ); ?>"> icon appears here,
then the message will not be deleted.  Clicking on either
icon toggles the message between deleted and undeleted.</p>

<?php
 if ( TWIGCheckACL( $login["username"], 4009, TWIGConvertAccess( "read" ) ) )
  {
  echo "<p>Lastly, the " . TWIGImage( $img["attachment"] ) . " icon indicates that the message indicated has an attachment in it.  The attachment can be viewed or downloaded when you are reading that message.  Clicking on this icon does nothing.</p>";
  }
?>


<p>To the right of the <?php echo $TWIGphrase["Status"] ?> column is the
"<?php echo $TWIGphrase["date"] ?>" column.  This column shows the date
and time that the message was received.  The time is generally based on
Greenwich mean time rather than local time.</p>

<p>Next is the <?php echo $TWIGphrase["from"] ?> column.  Here you will
see the email address (and possibly the name) of the person who sent you
echo email.</p>

<p>The final column of the mail list is the <?php echo $TWIGphrase["subject"] ?> column.
In this column you will see the subject line of each email message in the
list.  Clicking on the subject of any message will allow you to read that
message. See <?php echo TWIGlink( "Reading Email", "help", "mail", "subtopic=msgview") ?> for more information.</p>

<p>To the right of each message in the list, there is a check-box.  It is
used in conjunction with the buttons near the bottom of the page to allow
the same action to be carried out on multiple messages. By checking
(clicking on) the boxes next to one or more email messages and then
clicking "<?php echo $TWIGphrase["Delete Selected"] ?>" you can mark all
of those messages for deletion.  The "<?php echo $TWIGphrase["Undelete Selected"] ?>
button works in the same manner.</p>

<p>You can also move or copy one or more messages to another mail folder
using these check-boxes.  To do this, select the messages you wish to move
or copy and use the radio buttons to select either copy or move.  To the
right of the radio buttons is a menu containing all subscribed mail
folders.  Select the folder that is to be the destination for the messages
and then click "<?php echo $TWIGphrase["Go"] ?>".  The messages will be
moved/copied to the selected folder.  If you chose to move the messages,
you will see that the messages you moved will still be in their original
folder but will be marked for deletion.</p>

<p>All messages in the list can be selected or deselected using the
"<?php echo $TWIGphrase["Select All"] ?>" and "<?php echo $TWIGphrase["Select None"] ?>"
buttons.</p>
