ALTER TABLE twig_news_prefs ADD inline int4;
ALTER TABLE twig_contacts ADD type int4;
ALTER TABLE twig_contacts ADD userpers int4;
ALTER TABLE twig_mail_prefs ADD dreturn int4;
ALTER TABLE twig_mail_prefs ADD fromaddress varchar(128);
ALTER TABLE twig_schedule ADD recurtype INT;
ALTER TABLE twig_schedule ADD recurid INT;

UPDATE twig_schedule SET recurtype=0 WHERE recurtype!=1 OR recurtype is null;

CREATE TABLE twig_contacts_lists_entries (
   listid	int4 DEFAULT 0 NOT NULL,
   type		int4 DEFAULT 0 NOT NULL,
   item		int4 DEFAULT 0 NOT NULL,
   subitem	int4
);

CREATE INDEX twig_contacts_lists_entries_listid_index ON twig_contacts_lists_entries (listid);
CREATE INDEX twig_contacts_lists_entries_item_index ON twig_contacts_lists_entries (item);

CREATE SEQUENCE twsrecid start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1 ;
SELECT nextval ('twsrecid');

CREATE TABLE twig_schedule_recurring (
	id		int4 DEFAULT nextval ( 'twsrecid'),
	schid		int4,
	recurtype	int4 not null,
	schedule	int4,
	cycle		int4,
	"position"	int4,
	days		varchar(13),
	endtype		int4 not null,
	"end"		DATETIME not null,
	PRIMARY KEY	(id)
	);

CREATE INDEX twig_schedule_recurring_schid_index ON twig_schedule_recurring (schid);
CREATE INDEX twig_schedule_recurring_recurtype_index ON twig_schedule_recurring (recurtype);
CREATE INDEX twig_schedule_recurring_endtype_index ON twig_schedule_recurring (endtype);
CREATE INDEX twig_schedule_recurring_end_index ON twig_schedule_recurring ("end");

GRANT ALL ON twig_contacts_lists_entries TO nobody;
GRANT ALL ON twig_schedule_recurring TO nobody;

ALTER TABLE twig_announce RENAME date TO thedate;

ALTER TABLE twig_acls RENAME identity TO ident;
